package jp.co.nic.ngware.web.dashboard;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.google.common.collect.Lists;

import jp.co.nic.ngware.domain.Data;
import jp.co.nic.ngware.domain.MenuInfo;
import jp.co.nic.ngware.service.MenuService;

@Controller
public class DashboardController {

	@Autowired
	MenuService menuService;

	@RequestMapping("/dashboard")
	public String dashboard(Model model) {
		model.addAttribute("records", createSampleData());
		return "dashboard";
	}

	@RequestMapping("/menu")
	public @ResponseBody List<MenuInfo> menu() {
		return menuService.getMenu();
	}

	@RequestMapping("/user")
	public String user() {
		return "userSearch";
	}

	@RequestMapping("/tech")
	public String tech() {
		return "techSearch";
	}

	@RequestMapping("/userSetting")
	public String userSetting() {
		return "userSetting";
	}

	private List<Data> createSampleData() {
		List<Data> records = Lists.newArrayList();
		records.add(this.createData("引野", 15, "男"));
		records.add(this.createData("芦澤", 0, "男"));
		records.add(this.createData("テスト", 100, "女"));
		return records;
	}

	private Data createData(String name, Integer tensuu, String seibetsu) {
		Data data = new Data();
		data.setName(name);
		data.setSeibetsu(seibetsu);
		data.setTensu(tensuu);
		return data;
	}
}
