package jp.co.nic.ngware.util;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.http.Part;

import jp.co.nic.ngware.domain.FileInfo;

public final class ImageFileUtils {

	public static FileInfo getImageFileInfo(Path path) {
		File target = path.toFile();
		try (ImageInputStream iis = ImageIO.createImageInputStream(target)) {
			String ext = null;
			Iterator<ImageReader> readers = ImageIO.getImageReaders(path);
			if (!readers.hasNext()) {
				return new FileInfo();
			}
			ImageReader reader = readers.next();
			reader.setInput(path);
			String[] suffixes = reader.getOriginatingProvider().getFileSuffixes();
			FileInfo fileInfo = new FileInfo();
			fileInfo.setWidth(reader.getWidth(0));
			fileInfo.setHeight(reader.getHeight(0));
			if (suffixes == null || suffixes.length == 0) {
				ext = "";
			} else {
				ext = Arrays.stream(suffixes).filter(suffix -> suffix.length() == 3).findFirst().orElse("");
			}
			fileInfo.setExtension(ext);
			return fileInfo;
		} catch (Exception e) {
			e.printStackTrace();
			return new FileInfo();
		}
	}

	public static FileInfo getExtension(Part part) {
		try (ImageInputStream iis = ImageIO.createImageInputStream(part.getInputStream())) {
			String ext = null;
			Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
			if (!readers.hasNext()) {
				return new FileInfo();
			}
			ImageReader reader = readers.next();
			reader.setInput(iis);
			String[] suffixes = reader.getOriginatingProvider().getFileSuffixes();
			FileInfo fileInfo = new FileInfo();
			fileInfo.setWidth(reader.getWidth(0));
			fileInfo.setHeight(reader.getHeight(0));
			if (suffixes == null || suffixes.length == 0) {
				ext = "";
			} else {
				ext = Arrays.stream(suffixes).filter(suffix -> suffix.length() == 3).findFirst().orElse("");
			}
			fileInfo.setExtension(ext);
			return fileInfo;
		} catch (Exception e) {
			e.printStackTrace();
			return new FileInfo();
		}
	}

	public static FileInfo getExtension(Path path) {
		//		final InputStream inStream = new BufferedInputStream(
		//	            new FileInputStream("sampledata.txt"));
		try (ImageInputStream iis = ImageIO.createImageInputStream(path.toFile())) {
			String ext = null;
			Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
			if (!readers.hasNext()) {
				return new FileInfo();
			}
			ImageReader reader = readers.next();
			reader.setInput(iis);
			String[] suffixes = reader.getOriginatingProvider().getFileSuffixes();
			FileInfo fileInfo = new FileInfo();
			fileInfo.setWidth(reader.getWidth(0));
			fileInfo.setHeight(reader.getHeight(0));
			if (suffixes == null || suffixes.length == 0) {
				ext = "";
			} else {
				ext = Arrays.stream(suffixes).filter(suffix -> suffix.length() == 3).findFirst().orElse("");
			}
			fileInfo.setExtension(ext);
			return fileInfo;
		} catch (Exception e) {
			e.printStackTrace();
			return new FileInfo();
		}
	}
}
