package jp.co.nic.ngware.util;

import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import jp.co.nic.ngware.repository.UserDetailsServiceImpl.SecurityLoginUser;

public class ApplicationUtils {

	public static SecurityLoginUser getAuthentication() {
		Authentication auth = SecurityContextHolder.getContext().getAuthentication();
		if (!(auth instanceof AnonymousAuthenticationToken)) {
			return (SecurityLoginUser) auth.getPrincipal();
		}
		return null;
	}
}
