package jp.co.nic.ngware.util;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

import com.google.common.primitives.Ints;

@Service
public class ApplicationProperties {

	@Autowired
	private Environment env;

	public int getSessionTimeOut() {
		if (env.getProperty("application.timeout") == null) {
			return 30 * 60;
		}
		return Optional.ofNullable(this.to(env.getProperty("application.timeout")))
				.map(val -> val)
				.orElse(30 * 60);
	}

	private Integer to(String timeOutValue) {
		return Ints.tryParse(env.getProperty("application.timeout"));
	}
}
