package jp.co.nic.ngware.service;

import java.util.List;
import java.util.Optional;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import jp.co.nic.ngware.domain.UserInfo;
import jp.co.nic.ngware.domain.UserSelectCondition;
import jp.co.nic.ngware.mapper.UserMapper;

@Service
public class UserService {
	@Autowired
	private UserMapper userMapper;

	public List<UserInfo> getUsers(UserSelectCondition condition) {
		List<UserInfo> userList = userMapper.selectUsers(condition.getUserId(), condition.getAccountId(),
				condition.getFirstName(), condition.getLastName(), condition.getPositionId(),
				condition.getCellularPhone(), condition.getFirstNameKana(), condition.getLastNameKana());
		return userList;
	}

	public UserSelectCondition create(String userId, String accountId, String firstName, String lastName,
			String positionId,
			String cellularPhone, String firstNameKana, String lastNameKana) {
		UserSelectCondition con = new UserSelectCondition();
		con.setUserId(Optional.ofNullable(paramConvert(userId, false)).map(val -> Integer.valueOf(val)).orElse(null));
		con.setAccountId(paramConvert(accountId, false));
		con.setFirstName(paramConvert(firstName, true));
		con.setLastName(paramConvert(lastName, true));
		con.setCellularPhone(paramConvert(cellularPhone, true));
		con.setFirstNameKana(paramConvert(firstNameKana, true));
		con.setLastNameKana(paramConvert(lastNameKana, true));
		if (!StringUtils.isEmpty(positionId)) {
			con.setPositionId(Integer.valueOf(positionId));
		}

		return con;
	}

	private String paramConvert(String param, boolean isLike) {
		if (StringUtils.isEmpty(param)) {
			return null;
		}

		if (isLike) {
			return "%" + param + "%";
		}

		return param;
	}
}
