package jp.co.nic.ngware.service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import jp.co.nic.ngware.domain.TechUserInfo;
import jp.co.nic.ngware.mapper.TechMapper;

@Service
public class TechService {
	@Autowired
	private TechMapper techMapper;

	public List<TechUserInfo> getUsers(String[] conditions) {
		List<TechUserInfo> userList = techMapper.selectUsers(conditions);
		return userList;
	}

	public List<TechUserInfo> to(List<TechUserInfo> list) {
		Map<Integer, List<TechUserInfo>> result = list.stream()
				.collect(Collectors.groupingBy(user -> user.getUserId()));

		return list.stream()
				.map(tech -> {
					tech.setRowSpan(result.get(tech.getUserId()).size());
					return tech;
				})
				.collect(Collectors.toList());
	}

}
