package jp.co.nic.ngware.rest;

import java.util.List;
import java.util.Optional;

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.google.common.collect.Lists;

import jp.co.nic.ngware.domain.Data;

@RestController
public class SampleRestController {

	@RequestMapping(value = "/rest", method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
	public String rest(@RequestBody List<Data> request) {
		List<Data> requestedData = Optional.ofNullable(request).orElse(Lists.newArrayList());
		requestedData.stream().forEach(this::printConsole);
		return "success";
	}

	private void printConsole(Data data) {
		System.out
				.println("name=" + data.getName() + "  tensu=" + data.getTensu() + "  seibetsu=" + data.getSeibetsu());
	}
}
