package jp.co.nic.ngware.repository;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;

import jp.co.nic.ngware.domain.CompanyInfo;
import jp.co.nic.ngware.domain.UserInfo;
import jp.co.nic.ngware.mapper.CompanyMapper;
import jp.co.nic.ngware.mapper.UserMapper;
import jp.co.nic.ngware.repository.model.LoginUser;
import lombok.Getter;
import lombok.Setter;

@Component
public class UserDetailsServiceImpl implements UserDetailsService {

	@Autowired
	private UserMapper userMapper;

	@Autowired
	private CompanyMapper companyMapper;

	@Override
	public UserDetails loadUserByUsername(String accountId) throws UsernameNotFoundException {
		LoginUser domainUser = null;
		SecurityLoginUser loginInfo = null;
		try {
			// 入力したユーザーIDから認証を行うユーザー情報を取得する
			domainUser = userMapper.select(accountId);
			loginInfo = createSecurityLoginUser(domainUser);

		} catch (Exception e) {
			// 取得時にExceptionが発生した場合
			throw new UsernameNotFoundException("It can not be acquired User");
		}

		// ユーザー情報を取得できなかった場合
		if (domainUser == null) {
			throw new UsernameNotFoundException("User not found for login id: " + accountId);
		}

		List<GrantedAuthority> authorities = Lists.newArrayList();

		//Get Roles

		//		if (domainUser.getRoles() != null) {
		//			for (Role role : domainUser.getRoles()) {
		//				authorities.add(
		//						new SimpleGrantedAuthority(role.getName()));
		//			}
		//		}

		// ユーザー情報が取得できたらSpring Securityで認証できる形で戻す
		return loginInfo;
	}

	private SecurityLoginUser createSecurityLoginUser(LoginUser domainUser) {
		SecurityLoginUser loginInfo = new SecurityLoginUser(domainUser);
		loginInfo.setUserInfo(userMapper.selectUser(domainUser.getAccountId()));
		loginInfo.setCompany(companyMapper.selectCompany());
		//loginInfo.setDepartment(department);
		//loginInfo.setRoles(roles);
		return loginInfo;
	}

	public static class SecurityLoginUser extends org.springframework.security.core.userdetails.User {
		@Getter
		@Setter
		private UserInfo userInfo;

		@Getter
		@Setter
		private CompanyInfo company;

		@Getter
		@Setter
		private Object department;

		@Getter
		@Setter
		private Object roles;

		/**
		 * コンストラクタ
		 * @param user
		 */
		public SecurityLoginUser(LoginUser user) {
			// スーパークラスのユーザーID、パスワードに値をセットする
			// 実際の認証はスーパークラスのユーザーID、パスワードで行われる
			super(user.getAccountId(), user.getPassword(), AuthorityUtils.createAuthorityList("ROLE_USER"));
		}
	}
}
