package jp.co.nic.ngware.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;

import jp.co.nic.ngware.domain.UserInfo;
import jp.co.nic.ngware.repository.model.LoginUser;

@Mapper
public interface UserMapper {

	@Select("SELECT ACCOUNTID, PASSWORD, ENABLED FROM ACCESS_USER WHERE ACCOUNTID = #{accountId} AND ENABLED = 1")
	LoginUser select(String accountId);

	@Results({
		@Result(property = "userId", column = "USER_ID"),
		@Result(property = "accountId", column = "ACCOUNTID"),
		@Result(property = "firstName", column = "FIRST_NAME"),
		@Result(property = "lastName", column = "LAST_NAME"),
		@Result(property = "email", column = "EMAIL"),
		@Result(property = "confirmValue", column = "CONFIRM_VALUE"),
		@Result(property = "lastLogin", column = "LAST_LOGIN"),
		@Result(property = "passwordChanged", column = "PASSWORD_CHANGED"),
		@Result(property = "positionId", column = "POSITION_ID"),
		@Result(property = "inTelephone", column = "IN_TELEPHONE"),
		@Result(property = "outTelephone", column = "OUT_TELEPHONE"),
		@Result(property = "cellularPhone", column = "CELLULAR_PHONE"),
		@Result(property = "cellularMail", column = "CELLULAR_MAIL"),
		@Result(property = "cellularUid", column = "CELLULAR_UID"),
		@Result(property = "firstNameKana", column = "FIRST_NAME_KANA"),
		@Result(property = "lastNameKana", column = "LAST_NAME_KANA"),
		@Result(property = "createdUserId", column = "CREATED_USER_ID"),
		@Result(property = "updatedUserId", column = "UPDATED_USER_ID"),
		@Result(property = "created", column = "CREATED"),
		@Result(property = "modified", column = "MODIFIED")
      })
	@Select("SELECT USER_ID, ACCOUNTID, FIRST_NAME, LAST_NAME, EMAIL, CONFIRM_VALUE, LAST_LOGIN, PASSWORD_CHANGED, POSITION_ID, IN_TELEPHONE, OUT_TELEPHONE, CELLULAR_PHONE, CELLULAR_MAIL, CELLULAR_UID, FIRST_NAME_KANA, LAST_NAME_KANA, CREATED_USER_ID, UPDATED_USER_ID, CREATED, MODIFIED FROM M_USER WHERE ACCOUNTID = #{accountId} AND ENABLED = 1")
	UserInfo selectUser(String accountId);

	@Select(
	{"<script>",
		"SELECT  USER_ID,",
				"ACCOUNTID,",
				"FIRST_NAME,",
				"LAST_NAME,",
				"EMAIL,",
				"CONFIRM_VALUE,",
				"LAST_LOGIN,",
				"PASSWORD_CHANGED,",
				"POSITION_ID,",
				"IN_TELEPHONE,",
				"OUT_TELEPHONE,",
				"CELLULAR_PHONE,",
				"CELLULAR_MAIL,",
				"CELLULAR_UID,",
				"FIRST_NAME_KANA,",
				"LAST_NAME_KANA,",
				"CREATED_USER_ID,",
				"UPDATED_USER_ID,",
				"CREATED,",
				"MODIFIED",
		"FROM M_USER ",
		"WHERE ENABLED = 1",
		"  <if test=\"userId != null\">        AND USER_ID = #{userId}</if>",
		"  <if test=\"accountId != null\">     AND ACCOUNTID = #{accountId}</if>",
		"  <if test=\"firstName != null\">     AND FIRST_NAME like #{firstName}</if>",
		"  <if test=\"lastName != null\">      AND LAST_NAME like #{lastName}</if>",
		"  <if test=\"positionId != null\">    AND POSITION_ID = #{positionId}</if>",
		"  <if test=\"cellularPhone != null\"> AND CELLULAR_PHONE like #{cellularPhone}</if>",
		"  <if test=\"firstNameKana != null\"> AND FIRST_NAME_KANA like #{firstNameKana}</if>",
		"  <if test=\"lastNameKana != null\">  AND LAST_NAME_KANA like #{lastNameKana}</if>",
		//"ORDER BY M_USER ",
	"</script>"})
	List<UserInfo> selectUsers(@Param("userId")Integer userId,
								@Param("accountId")String accountId,
								@Param("firstName")String firstName,
								@Param("lastName")String lastName,
								@Param("positionId")Integer positionId,
								@Param("cellularPhone")String cellularPhone,
								@Param("firstNameKana")String firstNameKana,
								@Param("lastNameKana")String lastNameKana);
}
