package jp.co.nic.ngware.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import jp.co.nic.ngware.domain.TechUserInfo;

@Mapper
public interface TechMapper {

	@Select(
	{"<script>",
		" SELECT",
		"  MU.USER_ID",
		"  , MU.FIRST_NAME",
		"  , MU.LAST_NAME",
		"  , MU.EMAIL",
		"  , MU.POSITION_ID",
		"  , RU.MONTH_EXPERIENCE",
		"  , RU.DESIGN",
		"  , RU.IMPLEMENTATION",
		"  , RU.TEST",
		"  , RU.SUPPORT",
		"  , SKILL.SKILL_ID ",
		"  , SKILL.SKILL_NAME ",
		"  , ROW_NUMBER() OVER(PARTITION BY MU.USER_ID ORDER BY MU.USER_ID,SKILL.SKILL_ID) AS GROUP_SEQ ",
		"FROM",
		"  NGWARE.M_USER MU ",
		"  LEFT OUTER JOIN NGWARE.R_SKILL_USER RU ",
		"    ON MU.USER_ID = RU.USER_ID ",
		"  LEFT OUTER JOIN ( ",
		"    SELECT",
		"      M.SKILL_ID",
		"      , M.SKILL_NAME ",
		"    FROM",
		"      NGWARE.M_SKILL M ",
		"    WHERE",
		"      M.ENABLED = 1",
		"  ) SKILL ",
		"    ON RU.SKILL_ID = SKILL.SKILL_ID ",
		"<if test=\"skills != null\">",
		"WHERE ",
		"  SKILL.SKILL_ID IN ",
		"  <foreach item=\"item\" index=\"index\" collection=\"skills\" open=\"(\" separator=\",\" close=\")\"> ",
		"   #{item}",
		"  </foreach>",
		"</if>",
		"ORDER BY",
		"  MU.USER_ID,SKIll.SKILL_ID",
		"</script>"})
	List<TechUserInfo> selectUsers(@Param("skills")String[] skills);
}
