package jp.co.nic.ngware.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;

import jp.co.nic.ngware.domain.MenuInfo;
import jp.co.nic.ngware.domain.MenuInfo.MenuRole;

@Mapper
public interface MenuMapper {

	@Results({
		@Result(property = "orderId", column = "ORDER_ID"),
		@Result(property = "menuName", column = "MENU_NAME"),
		@Result(property = "url", column = "URL")
      })
	@Select("SELECT ORDER_ID, MENU_NAME, URL FROM M_MENU WHERE ENABLED = 1 ORDER BY ORDER_ID ASC")
	List<MenuInfo> select();

	@Results({
		@Result(property = "roleId", column = "ROLE_ID")
      })
	@Select("SELECT ROLE_ID FROM M_MENU_ROLE WHERE ORDER_ID = #{orderId} AND ENABLED = 1")
	List<MenuRole> selectRole(Integer orderId);
}
