package jp.co.nic.ngware.mapper;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;

import jp.co.nic.ngware.domain.CompanyInfo;

@Mapper
public interface CompanyMapper {

	@Results({
		@Result(property = "companyId", column = "COMPANY_ID"),
		@Result(property = "companyName", column = "COMPANY_NAME"),
		@Result(property = "companyNameKana", column = "COMPANY_NAME_KANA"),
		@Result(property = "zipcode", column = "ZIPCODE"),
		@Result(property = "address", column = "ADDRESS"),
		@Result(property = "telephone", column = "TELEPHONE"),
		@Result(property = "faxNumber", column = "FAX_NUMBER"),
		@Result(property = "url", column = "URL"),
		@Result(property = "created", column = "CREATED"),
		@Result(property = "modified", column = "MODIFIED")
      })
	@Select("SELECT COMPANY_ID, COMPANY_NAME, COMPANY_NAME_KANA, ZIPCODE, ADDRESS, TELEPHONE, FAX_NUMBER, URL, CREATED, MODIFIED FROM M_COMPANY WHERE ENABLED = 1")
	CompanyInfo selectCompany();
}
