package jp.co.nic.ngware.error;

import java.util.stream.Stream;

import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class SampleError {

	private static String ERROR_PAGE = "/error";

	// こんな感じ
	@RequestMapping(value = { "/4*", "/5*" })
	public ModelAndView defaultError(Exception ex) {
		ModelAndView m = new ModelAndView();
		m.addObject("message", ex.getMessage());
		m.addObject("stackTrace", ex.getStackTrace());

		m.setViewName(ERROR_PAGE);

		return m;
	}

	@Bean
	public EmbeddedServletContainerCustomizer containerCustomizer() {
		return new SmtCustmize();
	}

	private static class SmtCustmize implements EmbeddedServletContainerCustomizer {
		@Override
		public void customize(ConfigurableEmbeddedServletContainer container) {
			Stream.of(HttpStatus.values()).filter(status -> status.is4xxClientError() || status.is5xxServerError())
					.forEach(status -> {
						container.addErrorPages(new ErrorPage(status, ERROR_PAGE));
					});
		}
	}
}
