package jp.co.nic.ngware.config;

import java.util.HashMap;
import java.util.Map;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dialect.AbstractDialect;
import org.thymeleaf.dialect.IExpressionEnhancingDialect;

import jp.co.nic.ngware.thymeleaf.expression.SampleUtility;
import jp.co.nic.ngware.web.RequestInterceptor;

@Configuration
public class ThymeleafConfig extends WebMvcConfigurerAdapter {

	@Bean
	public SampleDialect myDialect() {
		return new SampleDialect();
	}

	public class SampleDialect extends AbstractDialect implements IExpressionEnhancingDialect {

		@Override
		public Map<String, Object> getAdditionalExpressionObjects(IProcessingContext processingContext) {
			Map<String, Object> map = new HashMap<>();
			map.put("sample", new SampleUtility());
			return map;
		}

		public String getPrefix() {
			return "sample";
		}
	}

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		registry.addInterceptor(new RequestInterceptor());
	}
}
