/*!
 * @file Species.h
 * @brief Q[̃N[`[ʂ̃vg^Cv
 * @date 2014/02/01
 * @author Deskull
 * 2014 Sikabane Works.
 */

#include "stdafx.h"
#include "GameElement.h"
#include "BaseStatusTable.h"

#pragma once

/*!
 * @class Species
 * @brief N[`[ʂ̃NX
 */
class Species : public GameElement
{

private:

	string name;   //!< N[`[̖O
	SOUL baseSoul; //!< {\E

	HEIGHT averageHeight;    //!< ϐg
	HEIGHT averageWeight;    //!< ϑ̏d

	FEED baseFeed; //!< {{l
	LEVEL divineLevel; //!< {_x

	BaseStatusTable baseStatus; /*!< {Xe[^X */

public:

	/*! 
	 * @brief SpeciesNXRXgN^(GameElementoΉ)
	 * @param id GameElementID
	 * @param TAG GameElement̃^O
	 * @param gameWorld gameWorldQƃ|C^
	 */
	Species::Species(ID id, TAG tag, GameWorld *gameWorld);

	/*! 
	 * @brief SpeciesNXRXgN^
	 */
	Species::Species(void);

	/*! 
	 * @brief SpeciesNXfXgN^
	 */
	Species::~Species(void);

	/*! 
	 * @brief N[`[ʂ̖OԂ
	 * @return O
	 */
	const string Species::GetName(void);

	/*! 
	 * @brief N[`[ʂ̊{\EʂA
	 * @return \E
	 */
	const SOUL Species::GetBaseSoul(void);

	/*! 
	 * @brief N[`[ʂ̕ϐgԂ
	 * @return ϐg
	 */
	const HEIGHT Species::GetAverageHeight(void);

	/*! 
	 * @brief N[`[ʂ̕ϑ̏dԂ
	 * @return ϑ̏d
	 */
	const WEIGHT Species::GetAverageWeight(void);

	/*! 
	 * @brief N[`[ʂ̊{{xԂ
	 * @return {{x
	 */
	const FEED Species::GetBaseFeed(void);

};
