/*!
 * @file GameSurfaceSDL.h
 * @brief GameSurfaceSDLNXƂ̑tvf̃vg^Cv
 * @date 2014/02/19
 * @author Deskull
 * 2014 Sikabane Works.
 */

#pragma once

#include "stdafx.h"

#include "Deeangband.h"
#include "Floor.h"
#include "GameSurface.h"
#include "GameWorld.h"
#include <SDL.h>
#include <SDL_image.h>
//#include <SDL_gfx.h>
#include <SDL_ttf.h>

/*! 
 * @class GameSurfaceSDL
 * @brief Q[̃CC^[tFCXNX(SDL)
 */
class GameSurfaceSDL : public GameSurface
{
private:
	Creature *viewCreaturePtr;
	Floor *viewFloorPtr;

	SDL_Renderer *renderer; 
	SDL_RWops *rwop;
	string error;
	SDL_Window *window;
	TTF_Font* font;
	SDL_Surface *titleSurface;
	SDL_Color color;
	SDL_Rect src;
	SDL_Rect title;

	void pushAnyKey(void);
	void initInterfaces(void);
	void drawCreatureStatus(Creature *creaturePtr);

	/*!
	 * @brief tȀ󋵂`悷
	 * @param floorPtr \tA̍\̎Qƃ|C^
	 * @param x N_XW
	 * @param y N_YW
	 * @param w \̃}X
	 * @param h \̃}X
	 * @return Ȃ
	 */
	void drawFloor(Floor *floorPtr, int x, int y, int w, int h);

public:

	/*!
	 * @brief Q[ʂĕ`悷
	 * @return Ȃ
	 */
	void GameSurfaceSDL::Redraw(void);

	/*!
	 * @brief w肳ꂽN[`[̃Xe[^X\
	 * @param creaturePtr \N[`[̎Qƃ|C^
	 * @return Ȃ
	 */
	void GameSurfaceSDL::ViewCreatureStatus(Creature *creaturePtr);

	/*!
	 * @brief \tA؂ւ
	 * @param creaturePtr \tA̎Qƃ|C^
	 * @return Ȃ
	 */
	void GameSurfaceSDL::SetFloor(Floor *floorPtr);

	/*!
	 * @brief RXgN^
	 */
	GameSurfaceSDL(void);

	/*!
	 * @brief fXgN^
	 */
	~GameSurfaceSDL(void);

	/*!
	 * @brief vC[R}h擾
	 * @return Q[R}hID
	 */
	GAME_COMMAND GetCommand(void);

	/*!
	 * @brief tA\̃tH[JXύXB
	 * @param coord W
	 * @return Ȃ
	 */
	void GameSurfaceSDL::FocusFloor(int x, int y);

};
