/*!
 * @file Dungeon.h
 * @brief Q[̃_Wƕtvf̃vg^Cv
 * @date 2013/12/11
 * @author Deskull
 * 2013 Sikabane Works.
 */

#include "stdafx.h"
#include "Camp.h"
#include "Species.h"
#include "Feature.h"
#include "GameElement.h"
#include "Deeangband.h"

#pragma once

typedef struct FixedFloorTable FixedFloorTable;
/*!
 * @brief ŒtAe[u
 */
struct FixedFloorTable
{
	bool StaticFixed; //!<ÓIŒ
	ID FixedFloorID;  //!<ŒtAID
	DEPTH MinDepth;   //!<ŒKw
	DEPTH MaxDepth;   //!<őKw
	NUMBER MinNum;    //!<Œᐶ
	NUMBER MaxNum;    //!<ő吶
	PPM Probability;  //!<m
};



/*! 
 * @class Dungeon
 * @brief _W̃NX
 */
class Dungeon : public GameElement
{
private:
	list<FixedFloorTable> fixFloorTableList; //!< ŒtÃXg
	DEPTH minDepth;      //!< JnKw
	DEPTH maxDepth;      //!< Ő[Kw
	ID outerWallFeature; //!< {Oǒn`ID
	ID innerWallFeature; //!< {ǒn`ID
	ID controlCamp;      //!< LwcID
	ID gurdianSpecies;   //!< _W̎ID

public:

	/*! 
	 * @brief DungeonNXRXgN^(GameElementoΉ)
	 * @param id GameElementID
	 * @param TAG GameElement̃^O
	 * @param gameWorld gameWorldQƃ|C^
	 */
	Dungeon::Dungeon(ID id, TAG tag, GameWorld *gameWorld);

	Dungeon::Dungeon(void);

	Dungeon::~Dungeon(void);

	/*!
	 * @brief _W̍ŒKwԂ
	 * @return _W̍ŒKw 
	 */
	DEPTH GetMinDepth(void);

	/*!
	 * @brief _W̍ōKwԂ
	 * @return _W̍ōKw 
	 */
	DEPTH GetMaxDepth(void);

	/*!
	 * @brief _W̊{Oǒn`Ԃ
	 * @return _W̊{Oǒn`ID
	 */
	ID GetOuterWallFeatureID(void);

	/*!
	 * @brief _W̊{Oǒn`Ԃ
	 * @return _W̊{Oǒn`Qƃ|C^
	 */
	Feature *GetOuterWallFeaturePtr(void);

	/*!
	 * @brief _W̊{ǒn`Ԃ
	 * @return _W̊{ǒn`QID
	 */
	ID GetInnerWallFeatureID(void);

	/*!
	 * @brief _W̊{ǒn`Ԃ
	 * @return _W̊{ǒn`Qƃ|C^
	 */
	Feature *GetInnerWallFeaturePtr(void);

	/*!
	 * @brief _WLwcԂ
	 * @return _W̏LwcID
	 */
	ID GetControlCampID(void);

	/*!
	 * @brief _WLwcԂ
	 * @return _W̏LwcQƃ|C^
	 */
	Camp *GetControlCampPtr(void);

	/*!
	 * @brief _W҃N[`[ʂԂ
	 * @return _W̏LwcQID
	 */
	ID GetGurdianSpeciesID(void);

	/*!
	 * @brief _W҃N[`[ʂԂ
	 * @return _W̏LwcQƃ|C^
	 */
	Species *GetGurdianSpeciesPtr(void);

};
