﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Windows.Controls;
using FooEditEngine;

namespace Outline
{
    class OutlineAnalyzer
    {
        const int MaxLevel = 6;

        public void Analyze(TreeView treeView1, AnalyzePattern info, LineToIndexTable LayoutLines)
        {
            if (info.Type == null)
                return;

            treeView1.Items.Clear();
            Stack<TreeViewItem> ParentList = new Stack<TreeViewItem>();

            for (int i = 0; i < LayoutLines.Count; i++)
            {
                string line = LayoutLines[i].ToString();
                int level = GetOutlineLevel(info, line);
                if (level == -1)
                {
                    if (i == LayoutLines.Count - 1)
                        this.SetLineCount(ParentList, i);
                    continue;
                }
                if (level >= MaxLevel)
                    continue;

                TreeViewItem newNode = new TreeViewItem();
                newNode.Header = line.Trim(new char[] { ' ', '\t', '.', Document.NewLine });
                newNode.Tag = new OutlineInfo(i, 1,level);

                TreeViewItem ParentNode;
                while (level <= ParentList.Count - 1)
                {
                    ParentNode = ParentList.Pop();
                    SetLineCount(ParentNode, i);
                }

                if (ParentList.Count == 0)
                {
                    treeView1.Items.Add(newNode);
                }else{
                    ParentNode = ParentList.Peek();
                    ParentNode.Items.Add(newNode);
                }

                ParentList.Push(newNode);
            }
        }

        private void SetLineCount(Stack<TreeViewItem> prevNodes, int row)
        {
            foreach (TreeViewItem node in prevNodes)
                if (node != null)
                    this.SetLineCount(node, row);
        }

        private void SetLineCount(TreeViewItem node, int row)
        {
            if (node == null)
                return;
            OutlineInfo info = (OutlineInfo)node.Tag;
            info.Count = row - info.StartRow;   //rowは発見した見出し項目があるので含まない
            node.Tag = info;
        }

        public bool IsOutlineTextFormat(string patternName)
        {
            return patternName == "WZ Text";
        }

        public int GetOutlineLevel(AnalyzePattern info, string str)
        {
            int level = -1;
            string[] patterns = info.Patterns;
            if (!IsOutlineTextFormat(info.Type))
            {
                for (int i = patterns.Length - 1; i >= 0; i--)
                {
                    Regex regex = new Regex(patterns[i], RegexOptions.IgnoreCase);
                    Match match = regex.Match(str);
                    if (match.Success)
                    {
                        level = i;
                        break;
                    }
                }
            }
            else
            {
                for (int i = 0; i < str.Length; i++)
                {
                    if (str[i] == '.')
                        level++;
                    else
                        break;
                }
            }
            return level;
        }

    }
}
