package tutorial;


import java.util.List;

import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Textbox;

public class SearchController extends SelectorComposer<Component> {

	private static final long serialVersionUID = 1L;

	@Wire
	private Textbox keywordBox;	//<textbox id="keywordBox" />
	@Wire
	private Listbox carListbox;	//<listbox id="carListbox"
	@Wire
	private Label nameLabel;	//<label id="nameLabel" />
	@Wire
	private Label companyLabel;	//<label id="companyLabel" />
	@Wire
	private Label priceLabel;	//<label id="priceLabel" />
	@Wire
	private Label descriptionLabel;	//<label id="descriptionLabel" />
	@Wire
	private Image previewImage;		//<image id="previewImage"


	private CarService carService = new CarServiceImpl();

	@Listen("onClick = #searchButton")	//<button id="searchButton"
	public void search(){
		String keyword = keywordBox.getValue();
		List<Car> result = carService.search(keyword);
		carListbox.setModel(new ListModelList<Car>(result));	//<template name="model">
						//<listcell label="${each.name}">
						//<listcell label="${each.company}">
						//<label value="${each.price}" />
	}

	@Listen("onSelect = #carListbox")	//<listbox id="carListbox"
	public void showDetail(){
		Car selected = carListbox.getSelectedItem().getValue();	//<template name="model">
		previewImage.setSrc(selected.getPreview());		//<image src="
		nameLabel.setValue(selected.getName());			//<label value=""
		companyLabel.setValue(selected.getCompany());		//<label value=""
		priceLabel.setValue(selected.getPrice().toString());	//<label value=""
		descriptionLabel.setValue(selected.getDescription());	//<label value=""
	}
	/**
	 * 初期表示処理
	 */
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
   }
}
