/*
 * JHPdf Free PDF Library : HPdfCIDType0Font.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.font;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfCMapEncoder;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.encoder.HPdfEncoder.HPdfEncoderType;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.graphics.HPdfTextWidth;
import net.sf.jhpdf.io.HPdfWriteStream;
import net.sf.jhpdf.pdfobject.HPdfArray;
import net.sf.jhpdf.pdfobject.HPdfDict;
import net.sf.jhpdf.pdfobject.HPdfFont;
import net.sf.jhpdf.pdfobject.HPdfString;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.pdfobject.font.HPdfCIDFontDef.HPdfCIDWidth;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfFontDefType;

/**
 * Class represents PDF CID Font Type0.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfCIDType0Font extends HPdfDescendantFont {

    private static final Logger logger = LoggerFactory.getLogger(HPdfCIDType0Font.class);
    
    HPdfCIDType0Font(HPdfType0Font parent, HPdfXref xref) {
        super(parent, xref);
        
        logger.trace("HPdfCIDType0Font#ctor");
        
        HPdfCIDFontDef fontDef = (HPdfCIDFontDef) parent.getFontDef();
        
        xref.add(this);
        
        this.addName("Type", "Font");
        this.addName("Subtype", "CIDFontType0");
        this.addNumber("DW", fontDef.getDw());
        this.addName("BaseFont", fontDef.getBaseFont());
        
        /* add 'DW2' element */
        HPdfArray array = new HPdfArray();
        this.add("DW2", array);
        int[] dw2 = fontDef.getDw2();
        array.addNumber(dw2[0]);
        array.addNumber(dw2[1]);
        
        /* add 'W' element */
        array = new HPdfArray();
        this.add("W", array);
        
        /* Create W array. */
        int saveCid = 0;
        HPdfArray subArray = null;
        for (HPdfCIDWidth w : fontDef.getWidths()) {
            if (w.getCID() != saveCid + 1 || subArray == null) {
                subArray = new HPdfArray();
                
                array.addNumber(w.getCID());
                array.add(subArray);
            }
            subArray.addNumber(w.getWidth());
            saveCid = w.getCID();
        }
        
        /* create descriptor */
        HPdfDict descriptor = new HPdfDict();
        xref.add(descriptor);
        this.add("FontDescriptor", fontDef.getDescriptor());
        
        descriptor.addName("Type", "FontDescriptor");
        descriptor.addName("FontName", fontDef.getBaseFont());
        descriptor.addNumber("Ascent", fontDef.getAscent());
        descriptor.addNumber("Descent", fontDef.getDescent());
        descriptor.addNumber("CapHeight", fontDef.getCapHeight());
        descriptor.addNumber("MissingWidth", fontDef.getMissingWidth());
        descriptor.addNumber("Flags", fontDef.getFlags());
        
        descriptor.add("FontBBox", HPdfArray.boxToArray(fontDef.getFontBbox()));
        
        descriptor.addNumber("ItalicAngle", fontDef.getItalicAngle());
        descriptor.addNumber("StemV", fontDef.getStemv());

        /* create CIDSystemInfo dictionary */
        HPdfCMapEncoder encoder = (HPdfCMapEncoder) parent.getEncoder();
        HPdfDict cidSystemInfo = new HPdfDict();
        
        this.add("CIDSystemInfo", cidSystemInfo);
        
        cidSystemInfo.add("Registry",
                new HPdfString(encoder.getRegistry(), null));
        cidSystemInfo.add("Ordering",
                new HPdfString(encoder.getOrdering(), null));
        cidSystemInfo.addNumber("Supplement", encoder.getSuppliment());
    }

    @Override
    void beforeWriteImpl(HPdfType0Font obj) {
        // nothing to do
    }
    
}
