/*
 * JHPdf Free PDF Library : HPdfLineAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.pdfobject.HPdfArray;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.graphics.HPdfPoint;
import net.sf.jhpdf.graphics.HPdfRect;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Line Annotation.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfLineAnnotation extends HPdfMarkupAnnotation {

    private static final Logger logger = LoggerFactory.getLogger(HPdfLineAnnotation.class);

    public enum HPdfLineAnnotEndingStyle {
        NONE("None"),
        SQUARE("Square"),
        CIRCLE("Circle"),
        DIAMOND("Diamond"),
        OPENARROW("OpenArrow"),
        CLOSEDARROW("ClosedArrow"),
        BUTT("Butt"),
        ROPENARROW("ROpenArrow"),
        RCLOSEDARROW("RClosedArrow"),
        SLASH("Slash"),
        ;
        private String name;
        HPdfLineAnnotEndingStyle(String name) {
            this.name = name;
        }
        public String getName() {
            return this.name;
        }
    }
    
    public enum HPdfLineAnnotCapPosition {
        INLINE("Inline"),
        TOP("Top"),
        ;
        private String name;
        HPdfLineAnnotCapPosition(String name) {
            this.name = name;
        }
        public String getName() {
            return this.name;
        }
    }
    
    public HPdfLineAnnotation(HPdfXref xref, HPdfRect rect, String text, HPdfEncoder encoder) {
        super(xref, rect, text, encoder);
        
        logger.trace("HPdfLineAnnotation#ctor");
        
        this.addName("SubType", "Line");
        
    }
    
    public void setPosition(HPdfPoint startPoint, HPdfLineAnnotEndingStyle startStyle,
            HPdfPoint endPoint, HPdfLineAnnotEndingStyle endStyle) {
        
        logger.trace("HPdfLineAnnotation#setPosition");
        
        HPdfArray lineEndPoints = new HPdfArray();
        
        this.add("L", lineEndPoints);
        
        lineEndPoints.addReal(startPoint.getX());
        lineEndPoints.addReal(startPoint.getY());
        lineEndPoints.addReal(endPoint.getX());
        lineEndPoints.addReal(endPoint.getY());
        
        HPdfArray lineEndStyles = new HPdfArray();
        
        this.add("LE", lineEndStyles);
        
        lineEndStyles.addName(startStyle.getName());
        lineEndStyles.addName(endStyle.getName());
    }
    
    public void setLeader(int leaderLen, int leaderExtLen, int leaderOffsetLen) {
        logger.trace("HPdfLineAnnotation#setLeader");
        
        this.addNumber("LL", leaderLen);
        this.addNumber("LLE", leaderExtLen);
        this.addNumber("LO", leaderOffsetLen);
    }
    
    public void setCaption(boolean showCaption, HPdfLineAnnotCapPosition position, int horzOffset, int vertOffset) {
        logger.trace("HPdfLineAnnotation#setCaption");
        
        this.addBoolean("Cap", showCaption);
        this.addName("CP", position.getName());
        
        HPdfArray capOffset = new HPdfArray();
        
        this.add("CO", capOffset);
        
        capOffset.addNumber(horzOffset);
        capOffset.addNumber(vertOffset);
    }
}
