/*
 * JHPdf Free PDF Library : HPdfCircleAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.graphics.HPdfRect;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Circle Annotation.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfCircleAnnotation extends HPdfMarkupAnnotation {

    private static final Logger logger = LoggerFactory.getLogger(HPdfCircleAnnotation.class);
    
    public HPdfCircleAnnotation(HPdfXref xref, HPdfRect rect, String text, HPdfEncoder encoder) {
        super(xref, rect, text, encoder);
        
        logger.trace("HPdfCircleAnnotation#ctor");
        
        this.addName("SubType", "Circle");
        
    }
}
