/*
 * JHPdf Free PDF Library : HPdfAbstractLinkAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.pdfobject.HPdfAnnotation;
import net.sf.jhpdf.pdfobject.HPdfArray;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.pdfobject.annotation.HPdfLinkAnnotation.HPdfHighlightMode;
import net.sf.jhpdf.graphics.HPdfRect;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Link Annotation.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfAbstractLinkAnnotation extends HPdfAnnotation {

    private static final Logger logger = LoggerFactory.getLogger(HPdfAbstractLinkAnnotation.class);
    
    protected HPdfAbstractLinkAnnotation(HPdfXref xref, HPdfRect rect) {
        super(xref, rect);
        
        logger.trace("HPdfAbstractLinkAnnotation#ctor");
        
        this.addName("SubType", "Link");
    }

    public final void setBorderStyle(float width, int dashOn, int dashOff) {
        // MEMO this method completely override superclass's one,
        // so no call super() .
        logger.trace("HPdfAbstractLinkAnnotation#setBorderStyle");

        this.validate();
        
        if (width < 0) {
            throw new HPdfException(HPdfErrorCode.HPDF_INVALID_PARAMETER, 0);
        }
        
        HPdfArray array = new HPdfArray();
        
        this.add("Border", array);
        
        array.addNumber(0);
        array.addNumber(0);
        array.addReal(width);
        
        if (dashOn != 0 && dashOff != 0) {
            HPdfArray dash = new HPdfArray();
            
            array.add(dash);
            dash.addNumber(dashOn);
            dash.addNumber(dashOff);
        }
    }

    public final void setHighlightMode(HPdfHighlightMode mode) {
        logger.trace("HPdfAbstractLinkAnnotation#setBorderStyle");
        
        this.validate();
        
        if (mode == HPdfHighlightMode.INVERT_BOX) {
            /* default value */
            this.removeElement("H");
        } else {
            this.addName("H", mode.getCode());
        }
        
    }

}
