/*
 * JHPdf Free PDF Library : HPdf3DC3DMeasure.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.HPdfPoint3D;
import net.sf.jhpdf.graphics.HPdfRGBColor;
import net.sf.jhpdf.graphics.HPdfTextWidth;

/**
 * Class represents PDF 3DC 3D measurement.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdf3DC3DMeasure extends HPdf3DMeasure {

    private static final Logger logger = LoggerFactory.getLogger(HPdf3DC3DMeasure.class);
    
    public HPdf3DC3DMeasure(HPdfXref xref, HPdfPoint3D firstAnchorPoint, HPdfPoint3D textAnchorPoint) {
        super();
        
        xref.add(this);
        
        this.addPoint3D("A1", firstAnchorPoint);
        this.addPoint3D("TP", textAnchorPoint);
        
        this.addName("Subtype", "3DC");
    }

}
