/*
 * JHPdf Free PDF Library : HPdfTextWidth.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.graphics;

/**
 * Class represents PDF text width data.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfTextWidth {
    // TODO only stub, needs methods definition.
    
    int numChars;
    int numWords;
    int width;
    int numSpace;
    
    public HPdfTextWidth() {
        this(0, 0, 0, 0);
    }
    
    public HPdfTextWidth(int numChars, int numWords, int width, int numSpace) {
        super();
        this.numChars = numChars;
        this.numWords = numWords;
        this.width = width;
        this.numSpace = numSpace;
    }
    
    public void resetValues() {
        this.numChars = 0;
        this.numWords = 0;
        this.width = 0;
        this.numSpace = 0;
    }

    public int getNumChars() {
        return this.numChars;
    }
    
    public void incNumChars() {
        ++this.numChars;
    }
    
    /**
     * @deprecated don't use this value (it may be change in the feature).<br>
     * use getNumSpace() as alternated.
     * @see getNumSpace()
     * @return
     */
    public int getNumWords() {
        return this.numWords;
    }
    
    public void incNumWords() {
        ++this.numWords;
    }

    public int getWidth() {
        return this.width;
    }
    
    public void addWidth(int addVal) {
        this.width += addVal;
    }
    
    public void setWidth(int width) {
        this.width = width;
    }

    public int getNumSpace() {
        return this.numSpace;
    }
    
    public void incNumSpace() {
        ++this.numSpace;
    }
}
