/*
 * JHPdf Free PDF Library : HPdfParseText.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.encoder;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder.HPdfByteType;

/**
 * Class represents container for string byte-encoding parser.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfParseText {
    // TODO only stub, needs methods definition.
    
    private byte[] text;
    
    private int len;
    
    private int index;
    
    private HPdfByteType byteType;
    
    public HPdfParseText() {
        super();
        this.text = null;
        
        this.index = -1;
        this.byteType = HPdfByteType.UNKNOWN;
    }
    
    public void setTarget(byte[] text, int len) {
        this.text = text;
        this.len = len;
        
        this.index = 0;
        this.byteType = HPdfByteType.SINGLE;
    }
}
