/*
 * JHPdf Free PDF Library : HPdfUtil.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Miscellenious utility methods class.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfUtil {

    private static final Logger logger = LoggerFactory.getLogger(HPdfUtil.class);

    private HPdfUtil() {
        // inhibits instantiation.
    }

    /**
     * returns character needs to be escaped.
     * @param c target character
     * @return if character needs to be escaped, true.
     */
    public static boolean needsEscape(char c) {
        return (c < 0x20 || 
                c > 0x7e || 
                //c == '' || // MEMO: I cannot recognize this code's mean... orz
                c == '%' || 
                c == '#' || 
                c == '/' || 
                c == '(' || 
                c == ')' || 
                c == '<' || 
                c == '>' || 
                c == '[' || 
                c == ']' || 
                c == '{' || 
                c == '}' );
    }
    
    public static String PDF_WHITE_SPACES =
            "\u0000\t\n\f\r\u0020";
    
    /**
     * returns character is 'whitespace' in PDF semantics.
     * @param c target character
     * @return if character is 'whitespace', true.
     */
    public static boolean isWhiteSpace(char c) {
        return (PDF_WHITE_SPACES.indexOf(c) >= 0);
    }

    
    /**
     * check String consists of only 'single-byte character's.
     * @param s String for check
     * @return true or false
     */
    public static boolean isSingleByteOnly(String s) {
        // FIXME: more efficient code please...
        boolean result = true;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) > 0xff) {
                result = false;
                break;
            }
        }
        return result;
    }
}
