/*
 * JHPdf Free PDF Library : HPdfException.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf;

/**
 * Exception class represents errors happened in JHPDF Library.
 * It will be a super-class for some JHPDF Exceptions.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfException extends RuntimeException {
    
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private int errorNo;
    private int detailNo;
    
    /**
     * ctor.
     * @param errorNo major error number.(corresponds libHaru's one.)
     * @param detailNo minor error number.(corresponds libHaru's one.)
     */
    public HPdfException(int errorNo, int detailNo) {
        super();
        myInit(errorNo, detailNo);
    }
    
    /**
     * ctor with a cause Exception.
     * @param errorNo major error number.(corresponds libHaru's one.)
     * @param detailNo minor error number.(corresponds libHaru's one.)
     * @param cause the cause of this error.
     */
    public HPdfException(int errorNo, int detailNo, Throwable cause) {
        super(cause);
        myInit(errorNo, detailNo);
    }
    
    private final void myInit(int errorNo, int detailNo) {
        this.errorNo = errorNo;
        this.detailNo = detailNo;
    }
    
    /**
     * returns major error number.(corresponds libHaru's errorNo.)
     * @return major error number
     */
    public final int getErrorNo() {
        return errorNo;
    }
    
    /**
     * returns minor error number.(corresponds libHaru's detailNo.)
     * @return minor error number
     */
    public final int getDetailNo() {
        return detailNo;
    }
    
    @Override
    public String getMessage() {
        return createMessage();
    }
    
    /**
     * returns message string. This string may be shown as getMessage() methods result.<br>
     * Subclasses should customize this method for their own information.
     * @return human-readable error message.
     */
    protected String createMessage() {
        return String.format("ERROR: error_no=%04X, detail_no=%d",
            getErrorNo(), getDetailNo() );
    }
}
