/*
 * JHPdf Free PDF Library : JpegDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import java.io.File;

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfDocument.HPdfCompressionMode;


public class JpegDemo implements DemoEntry {
    public static void main(String[] args) {
        new JpegDemo().demo(args);
    }
    
    private static final String F_NAME = "JpegDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            pdf.setCompressionMode(HPdfCompressionMode.ALL);
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Helvetica", null);
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();
            
            page.setWidth(650);
            page.setHeight(500);
            
            HPdfDestination dst = page.createDestination();
            dst.setXYZ(0, page.getHeight(), 1);
            pdf.setOpenAction(dst);
            
            page.beginText();
            page.setFontAndSize(font, 20);
            page.moveTextPos(220, page.getHeight() - 70);
            page.showText("JpegDemo");
            page.endText();
            
            page.setFontAndSize(font, 12);
            
            drawImage(pdf, "rgb.jpg", 70, page.getHeight() - 410,
                "24bit color image");
            drawImage(pdf, "gray.jpg", 340, page.getHeight() - 410,
                "8bit grayscale image");
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    private void drawImage(HPdfDocument pdf, String fileName, float x, float y, String text) {
        
        HPdfPage page = pdf.getCurrentPage();
        
        String filename1 = "images" + File.separator + fileName;
        
        HPdfImage image = pdf.loadJpegImageFromFile(filename1);
        
        /* Draw image to the canvas. */
        page.drawImage(image, x, y, image.getWidth(), image.getHeight());
        
        /* Print the text. */
        page.beginText();
        page.setTextLeading(16);
        page.moveTextPos(x, y);
        page.showTextNextLine(fileName);
        page.showTextNextLine(text);
        page.endText();
    }
    
}
