/*
 * JHPdf Free PDF Library : ArcDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/arc_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.graphics.*;


public class ArcDemo implements DemoEntry {
    public static void main(String[] args) {
        new ArcDemo().demo(args);
    }
    
    private static final String F_NAME = "ArcDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        GridSheet grid = new GridSheet();
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();

            page.setHeight(220);
            page.setWidth(200);

            /* draw grid to the page */
            grid.printGrid (pdf, page);

            /* draw pie chart
             *
             *   A: 45% Red
             *   B: 25% Blue
             *   C: 15% green
             *   D: other yellow
             */

            /* A */
            page.setRGBFill(1.0F, 0, 0);
            page.moveTo(100, 100);
            page.lineTo(100, 180);
            page.arc(100, 100, 80, 0, 360 * 0.45F);
            HPdfPoint pos = page.getCurrentPos();
            page.lineTo(100, 100);
            page.fill();

            /* B */
            page.setRGBFill(0, 0, 1.0F);
            page.moveTo(100, 100);
            page.lineTo(pos.getX(), pos.getY());
            page.arc(100, 100, 80, 360 * 0.45F, 360 * 0.7F);
            pos = page.getCurrentPos();
            page.lineTo(100, 100);
            page.fill();

            /* C */
            page.setRGBFill(0, 1.0F, 0);
            page.moveTo(100, 100);
            page.lineTo(pos.getX(), pos.getY());
            page.arc(100, 100, 80, 360 * 0.7F, 360 * 0.85F);
            pos = page.getCurrentPos();
            page.lineTo(100, 100);
            page.fill();

            /* D */
            page.setRGBFill(1.0F, 1.0F, 0);
            page.moveTo(100, 100);
            page.lineTo(pos.getX(), pos.getY());
            page.arc(100, 100, 80, 360 * 0.85F, 360);
            pos = page.getCurrentPos();
            page.lineTo(100, 100);
            page.fill();

            /* draw center circle */
            page.setGrayStroke(0);
            page.setGrayFill(1);
            page.circle(100, 100, 30);
            page.fill();
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
}
