## -*- coding: utf-8 -*-
/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.hardware.photography;

import static android.hardware.photography.CameraMetadata.Key;

/**
 * ! Do not edit this file directly !
 *
 * Generated automatically from ${java_class}Keys.mako
 *
 * TODO: Include a hash of the input files here that the build can check.
 */

<%page args="java_class, xml_kind" />\
/**
 * The base class for camera controls and information.
 *
 * This class defines the basic key/value map used for querying for camera
 * characteristics or capture results, and for setting camera request
 * parameters.
 *
 * @see ${java_class}
 * @see CameraMetadata
 * @hide
 **/
##
## Function to generate an enum
<%def name="generate_enum(entry)">
            % if entry.applied_visibility == 'hidden':
            /**
             * @hide
             */
            %endif
            public static final class ${entry.get_name_minimal() | pascal_case}Key extends Key<${jtype_boxed(entry)}> {
                public enum Enum {
                  % for value,last in enumerate_with_last(entry.enum.values):
                    ${value.name | jidentifier}${"," if not last else ";"}
                  % endfor
                }

              % for value in entry.enum.values:
                public static final Enum ${value.name | jidentifier} = Enum.${value.name | jidentifier};
              % endfor

                // TODO: remove requirement for constructor by making Key an interface
                private ${entry.get_name_minimal() | pascal_case}Key(String name) {
                    super(name, ${jtype_boxed(entry)}.class);
                }

              % if entry.enum.has_values_with_id:
                static {
                    CameraMetadata.registerEnumValues(${jenum(entry.enum)}.class, new int[] {
                      % for (value, last) in enumerate_with_last(entry.enum.values):
                        ${enum_calculate_value_string(value)}${"," if not last else ""}  // ${value.name | jidentifier}
                      % endfor
                    });
                }
              % endif
            }
</%def>\
##
## Generate a list of only Static, Controls, or Dynamic properties.
<%def name="single_kind_keys(java_name, xml_name)">\
public final class ${java_name}Keys {
% for outer_namespace in metadata.outer_namespaces: ## assumes single 'android' namespace
  % for section in outer_namespace.sections:
    % if section.find_first(lambda x: isinstance(x, metadata_model.Entry) and x.kind == xml_name) and \
         any_visible(section, xml_name, ('public','hidden') ):
    % if not any_visible(section, xml_name, ('public')):
    /**
     * @hide
     */
    %endif
    public static final class ${section.name | pascal_case} {
      % for inner_namespace in get_children_by_filtering_kind(section, xml_name, 'namespaces'):
## We only support 1 level of inner namespace, i.e. android.a.b and android.a.b.c works, but not android.a.b.c.d
## If we need to support more, we should use a recursive function here instead.. but the indentation gets trickier.
        public static final class ${inner_namespace.name| pascal_case} {
          % for entry in filter_visibility(inner_namespace.merged_entries, ('hidden','public')):
            % if entry.enum and not (entry.typedef and not entry.typedef.languages.get('java')):
${generate_enum(entry)}
            % if entry.applied_visibility == 'hidden':
            /**
             * @hide
             */
            %endif
            public static final Key<${jtype_boxed(entry)}> ${entry.get_name_minimal() | csym} =
                    new ${entry.get_name_minimal() | pascal_case}Key("${entry.name}");
            % else:
            % if entry.applied_visibility == 'hidden':
            /**
             * @hide
             */
            %endif
            public static final Key<${jtype_boxed(entry)}> ${entry.get_name_minimal() | csym} =
                    new Key<${jtype_boxed(entry)}>("${entry.name}", ${jclass(entry)});
            % endif
          % endfor
        }
      % endfor
      % for entry in filter_visibility( \
          get_children_by_filtering_kind(section, xml_name, 'merged_entries'), \
                                         ('hidden', 'public')):
        % if entry.enum and not (entry.typedef and entry.typedef.languages.get('java')):
${generate_enum(entry)}
          % if entry.applied_visibility == 'hidden':
        /**
         * @hide
         */
          %endif
        public static final Key<${jtype_boxed(entry)}> ${entry.get_name_minimal() | csym} =
                new ${entry.get_name_minimal() | pascal_case}Key("${entry.name}");
        % else:
          % if entry.applied_visibility == 'hidden':
        /**
         * @hide
         */
          %endif
        public static final Key<${jtype_boxed(entry)}> ${entry.get_name_minimal() | csym} =
                new Key<${jtype_boxed(entry)}>("${entry.name}", ${jclass(entry)});
        % endif
      % endfor

    }

    % endif
  % endfor
% endfor
}
</%def>\
##
## Static properties only
##${single_kind_keys('CameraPropertiesKeys', 'static')}
##
## Controls properties only
##${single_kind_keys('CaptureRequestKeys', 'controls')}
##
## Dynamic properties only
##${single_kind_keys('CaptureResultKeys', 'dynamic')}
${single_kind_keys(java_class, xml_kind)}
