package systemModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import model.ClassEntity;
import model.DecoratedEntity;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassColumnMaster extends ClassEntity {

	/**
	 *
	 */
	public ClassColumnMaster() {
		this.m_tableName = "COLUMN_MASTER";
	}

	/**
	 *
	 * @param db
	 */
	public ClassColumnMaster(DBAccessWrapper db) {
		super(db, "COLUMN_MASTER");
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<ColumnMaster> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException, IOException {

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;

		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects(m_tableName);
		ArrayList<String> selectParams = new ArrayList<String>();
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			selectParams.add(columnId);
		}

		ArrayList<ArrayList<String>> rows = m_db.select(selectParams, m_tableName, condition, conditionTypes, conditionValues);
		ArrayList<ColumnMaster> objects = new ArrayList<ColumnMaster>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			ColumnMaster object = new ColumnMaster(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}

	/**
	 *
	 * @param tableName
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<ColumnMaster> selectWithTable(String tableName) throws SQLException, ClassNotFoundException, IOException {

		String conditionMaster = "";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		conditionMaster = "TABLE_ID = ?";
		conditionTypes.add("string");
		conditionValues.add(tableName.toUpperCase());

		return select(conditionMaster, conditionTypes, conditionValues);
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<DecoratedEntity> selectWithColumnSetting(String masterCondition, String settingCondition, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException, IOException {

		String strbTableName = "COLUMN_MASTER T1, COLUMN_SETTING T2";

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;

		ArrayList<MetaColumn> metaColumns1 = classMetaColumn.getMetaObjects("COLUMN_MASTER");
		ArrayList<String> selectParams1 = new ArrayList<String>();
		for (int ii = 0; ii < metaColumns1.size(); ++ii) {
			MetaColumn metaColumn = metaColumns1.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			selectParams1.add(columnId);
		}

		ArrayList<MetaColumn> metaColumns2 = classMetaColumn.getMetaObjects("COLUMN_SETTING");
		ArrayList<String> selectParams2 = new ArrayList<String>();
		for (int ii = 0; ii < metaColumns2.size(); ++ii) {
			MetaColumn metaColumn = metaColumns2.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			selectParams2.add(columnId);
		}

		ArrayList<String> selectParams = new ArrayList<String>();
		for (int ii = 0; ii < selectParams1.size(); ++ii) {
			String selectParam = selectParams1.get(ii);
			selectParam = "T1." + selectParam + " AS COLUMN_MASTER_" + selectParam;
			selectParams.add(selectParam);
		}
		for (int ii = 0; ii < selectParams2.size(); ++ii) {
			String selectParam = selectParams2.get(ii);
			selectParam = "T2." + selectParam + " AS COLUMN_SETTINGl_" + selectParam;
			selectParams.add(selectParam);
		}

		StringBuilder condition = new StringBuilder();

		condition.append("T1.IDENTIFICATION = T2.SUPER_IDENTIFICATION");
		if(!masterCondition.isEmpty()) {
			masterCondition = masterCondition.toUpperCase();
			masterCondition = masterCondition.replaceAll("SELF", "T1");
			condition.append(" AND ");
			condition.append(" ( ");
			condition.append(masterCondition);
			condition.append(" ) ");
		}

		if(!settingCondition.isEmpty()) {
			settingCondition = settingCondition.toUpperCase();
			settingCondition = settingCondition.replaceAll("SELF", "T2");
			condition.append(" AND ");
			condition.append(" ( ");
			condition.append(settingCondition);
			condition.append(" ) ");
		}


		ArrayList<String> conditionTypes = new ArrayList<String>();

		String masterConditions[] = masterCondition.split(" ");
		for (int ii = 0; ii < masterConditions.length; ++ii){
			String key = masterConditions[ii].toUpperCase();
			String keys[] = key.split("\\.");
			for (int jj = 0; jj < keys.length; ++jj){
				if ( m_propTypes.containsKey(keys[jj]) ) {
					String type = m_propTypes.get(keys[jj]);
					conditionTypes.add(type);
				}
			}
		}

		Map<String, String> propTypes = new HashMap<String, String>();
		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects("COLUMN_SETTING");
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			String columnType = metaColumn.getProperty("COLUMN_TYPE");
			propTypes.put(columnId, columnType);
		}

		String settingConditions[] = settingCondition.split(" ");
		for (int ii = 0; ii < settingConditions.length; ++ii){
			String key = settingConditions[ii].toUpperCase();
			String keys[] = key.split("\\.");
			for (int jj = 0; jj < keys.length; ++jj){
				if ( propTypes.containsKey(keys[jj]) ) {
					String type = propTypes.get(keys[jj]);
					conditionTypes.add(type);
				}
			}
		}

		ArrayList<String> sortParams = new ArrayList<String>();
		sortParams.add("T2.STRUCT_ORDER");

		ArrayList<ArrayList<String>> rows = m_db.selectWithOrderBy(selectParams, strbTableName, condition.toString(), conditionTypes, conditionValues, sortParams);
		ArrayList<DecoratedEntity> objects = new ArrayList<DecoratedEntity>();
		for (int ii = 0; ii < rows.size(); ++ii) {

			ArrayList<String> row = rows.get(ii);
			ArrayList<String> row1 = new ArrayList<String>();
			ArrayList<String> row2 = new ArrayList<String>();

			int index = 0;
			for (int jj = 0; jj < selectParams1.size(); ++jj, ++index) {
				row1.add(row.get(index));
			}
			for (int jj = 0; jj < selectParams2.size(); ++jj, ++index) {
				row2.add(row.get(index));
			}

			DecoratedEntity decoEntity = new DecoratedEntity();
			ColumnMaster object1 = new ColumnMaster(m_db, selectParams1, row1);
			ColumnSetting object2 = new ColumnSetting(m_db, selectParams2, row2);

			decoEntity.originator = object1;
			decoEntity.decorator = object2;
			objects.add(decoEntity);
		}

		return objects;
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ColumnMaster create(ArrayList<String> insertParams, ArrayList<Object> insertValues) throws SQLException, ClassNotFoundException, IOException {
		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.add("IDENTIFICATION");

		ArrayList<ArrayList<String>> rows = super.insert(insertParams, insertValues, selectParams);

		String identificaton = rows.get(0).get(0);
		String condition = "identification = ?";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionTypes.add("int");
		conditionValues.add(identificaton);

		ArrayList<ColumnMaster> objects;
		objects = select(condition, conditionTypes, conditionValues);

		return objects.get(0);
	}
}
