package objectModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import model.Entity;
import model.NavigationItem;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Partner extends Entity {

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 */
	public Partner(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values) {
		super(db, keys,values, "PARTNER");
	}

	/**
	 *
	 * @return
	 */
	public String number() {
		return m_properties.get("PARTNER_NUMBER");
	}

	/**
	 *
	 * @param number
	 */
	public void number(String number) {
		m_properties.put("PARTNER_NUMBER", number);
	}

	/**
	 *
	 * @param inSortParams
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<NavigationItem> navigatePart(ArrayList<String> inSortParams) throws SQLException, ClassNotFoundException, IOException {

		String strbTableNames[] = {"PARTNER_PART", "PART"};

		StringBuilder condition = new StringBuilder();
		condition.append("T1.LEFT_IDENTIFICATION = ? AND T1.RIGHT_IDENTIFICATION = T2.IDENTIFICATION");

		ArrayList<NavigationItem> objects = navigate("", strbTableNames, condition.toString(), inSortParams);
		return objects;
	}

	/**
	 *
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public int delete() throws SQLException, ClassNotFoundException, IOException {

		int result = 0;
		String deleteCondition = "";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		//partner_part削除
		deleteCondition = "left_identification = ?";
		conditionTypes.clear();
		conditionTypes.add("int");
		conditionValues.clear();
		conditionValues.add(identification());
		result = m_db.delete("PARTNER_PART", deleteCondition, conditionTypes, conditionValues);
		if ( result < 0 ) {
			return result;
		}

		//part削除
		return super.delete();
	}
}
