package objectModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import model.ClassRelation;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassAccountPart  extends ClassRelation {

	/**
	 *
	 */
	public ClassAccountPart() {
		this.m_tableName = "ACCOUNT_PART";
	}

	/**
	 *
	 * @param db
	 */
	public ClassAccountPart(DBAccessWrapper db) {
		super(db, "ACCOUNT_PART");
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<AccountPart> select(String condition, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException, IOException {

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;

		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects(m_tableName);
		ArrayList<String> selectParams = new ArrayList<String>();
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			selectParams.add(columnId);
		}

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionValues);
		ArrayList<AccountPart> objects = new ArrayList<AccountPart>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			AccountPart object = new AccountPart(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}

	/**
	 *
	 * @param upper_identification
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public long getMaxStructOrder(String left_identification) throws SQLException, ClassNotFoundException {
		return super.getMaxStructOrder("LEFT_IDENTIFICATION", left_identification);
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public AccountPart create(Account left, Part right) throws SQLException, ClassNotFoundException, IOException {

		long structOrder = getMaxStructOrder(left.identification());
		++structOrder;

		ArrayList<String> insertParams = new ArrayList<String>();
		ArrayList<Object> insertValues = new ArrayList<Object>();

		insertParams.clear();
		insertParams.add("LEFT_IDENTIFICATION");
		insertParams.add("RIGHT_IDENTIFICATION");
		insertParams.add("STRUCT_ORDER");

		insertValues.clear();
		insertValues.add(left.identification());
		insertValues.add(right.identification());
		insertValues.add(structOrder);

		String identificaton = super.create(insertParams, insertValues);
		String condition = "identification = ?";
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionValues.add(identificaton);

		ArrayList<AccountPart> objects;
		objects = select(condition, conditionValues);
		return objects.get(0);
	}
}
