/**
 *
 */

var colNames1 = null;
var colModels1 = null;

var colNames2 = null;
var colModels2 = null;

var tblHeightMargin = 0;
var tblWidthMargin = 0;

var tblHeight1 = 0;
var tblWidth1 = 0;

var tblHeight2 = 0;
var tblWidth2 = 0;

var currentAccountType = "";

var bolCreateTable1 = true;
var bolCreateTable2 = true;
var bolSetFrozenColumns = true;

/**
 *
 */
function onLoadAction() {

	console.log("onLoadAction");

	//高さ設定
	tblHeightMargin = 190;
	var height = $(window).height() - tblHeightMargin;
	tblHeight1 = height;
	tblHeight2 = height;

	//幅設定
	tblWidthMargin = 15
	var width = $(window).width() - tblWidthMargin;
	tblWidth1 = 240;
	tblWidth2 = width - tblWidth1;

	$.ajax({
		url: "columnmanager",
	    type: "GET",
	    async : false,
		cache : false,
		data: {"tableid":"account","columns":"IDENTIFICATION,NAME"},
		success: function(data, status, xhr) {
			// 通信成功時の処理
			colNames1 = new Array();
			colModels1 = new Array();
			columnXmlToArray(data, colNames1, colModels1);
			colModels1[1]['sortable'] = false;
		},
		error: function(xhr, status, error) {
			// 通信失敗時の処理
			return;
		},
		complete: function(xhr, status) {
			// 通信完了時の処理
			return;
	    }
	});

	$.ajax({
		url: "columnmanager",
	    type: "GET",
	    async : false,
		cache : false,
		data: {"tableid":"part"},
		success: function(data, status, xhr) {
			// 通信成功時の処理
			colNames2 = new Array();
			colModels2 = new Array();
			columnXmlToArray(data, colNames2, colModels2);
			colModels2[0]['frozen'] = true;
			colModels2[1]['frozen'] = true;
			colModels2[2]['frozen'] = true;
			onReloadAction();
		},
		error: function(xhr, status, error) {
			// 通信失敗時の処理
			return;
		},
		complete: function(xhr, status) {
			// 通信完了時の処理
			return;
	    }
	});

	//イベント定義
	$(window).bind('resize', onResizeWindow );
	jQuery('#sel_part01').bind('change', onReloadAction);
	jQuery('#btn_part01').bind('click', onClickButton01);
	jQuery('#btn_part02').bind('click', onClickButton02);
	jQuery('#btn_part03').bind('click', onClickButton03);
	jQuery('#btn_part04').bind('click', onClickButton04);
	jQuery('#btn_part05').bind('click', onClickButton05);
	jQuery('#btn_part06').bind('click', onClickButton06);
	jQuery('#btn_part07').bind('click', onClickButton07);
}

/**
 *
 */
function onResizeWindow() {

	console.log("onResizeWindow");

	//高さ設定
	var height = $(window).height() - tblHeightMargin;
	tblHeight1 = height;
	tblHeight2 = height;

	//幅設定
	var width = $(window).width() - tblWidthMargin;
	tblWidth1 = tblWidth1;
	tblWidth2 = width - tblWidth1;

	console.log("onResizeWindow #tbl_jqgrid01 height:" + tblHeight1);
	console.log("onResizeWindow #tbl_jqgrid01 width :" + tblWidth1);
	console.log("onResizeWindow #tbl_jqgrid02 height:" + tblHeight2);
	console.log("onResizeWindow #tbl_jqgrid02 width :" + tblWidth2);

	jQuery("#tbl_jqgrid01").setGridHeight(tblHeight1);
	jQuery('#tbl_jqgrid01').setGridWidth(tblWidth1);

	jQuery("#tbl_jqgrid02").setGridHeight(tblHeight1);
	jQuery('#tbl_jqgrid02').setGridWidth(tblWidth2);
}

/**
 *
 */
function onReloadAction() {

	console.log("onReloadAction");
	console.log("onReloadAction currentAccountType:" + currentAccountType);

	var rowid = jQuery("#tbl_jqgrid01").getGridParam("selrow");
	var accountType = jQuery('#sel_part01 option:selected').val();

	$.ajax({
		url: "accountmanager",
	    type: "GET",
		cache : false,
		data: {"columns":"IDENTIFICATION,NAME","treeGrid":"true", "accountType":accountType},
		success: function(data, status, xhr) {
			// 通信成功時の処理
			createTable1(data);

			if (currentAccountType == accountType && rowid != null){
				jQuery("#tbl_jqgrid01").setSelection(rowid, true);
			}
			else {
				currentAccountType = accountType;
				createTable2("");
			}

			updateButtonState(false);
		},
		error: function(xhr, status, error) {
			// 通信失敗時の処理
		},
		complete: function(xhr, status) {
			// 通信完了時の処理
	    }
	});
}

/**
 *
 * @param tableId
 * @param tableName
 * @param tableHeight
 * @param tableWidth
 * @param xmldata
 * @param colNames
 * @param colModels
 */
function createTable1(xmldata) {

	console.log("createTable1");

	if ( !bolCreateTable1 ) {
		bolCreateTable1 = true;
		return;
	}

	//テーブル生成
	jQuery("#tbl_jqgrid01").GridUnload();
	jQuery("#tbl_jqgrid01").jqGrid({
		datastr				: xmldata,
		datatype			: "xmlstring",
		caption				: "勘定科目",
		colNames			: colNames1,
		colModel			: colModels1,
		rowNum				: 100,
		height				: tblHeight1,
		width				: tblWidth1,
		pager				: "#div_jqgrid_navi01",
		recordtext			: "",
		viewrecords			: false,
		multiselect			: false,
		shrinkToFit			: true,
		treeGrid			: true,
		cellEdit			: false,
		scrollrows			: true,
		onSelectRow			: function(rowid) {
			console.log("createTable1 onSelectRowTreeGrid");
			console.log("createTable1 onSelectRowTreeGrid rowid:" + rowid);
			createTable2(rowid);
			updateButtonState(false);
		},
		treeGridModel		: 'adjacency',
		ExpandColumn		: colModels1[1]['name']
	});//.navGrid('#div_jqgrid_navi01',{add: false, edit: false, del: false, refresh: false, search: false});
}

/**
 *
 * @param tableId
 * @param tableName
 * @param tableHeight
 * @param tableWidth
 * @param xmldata
 * @param colNames
 * @param colModels
 */
function createTable2(rowid) {

	console.log("createTable2");

	if ( !bolCreateTable2 ) {
		bolCreateTable2 = true;
		return;
	}

	var option = "";
	if (rowid != null && rowid != "") {
		var identification = jQuery("#tbl_jqgrid01").getCell(rowid, 0);
		console.log("createTable2 rowid:" + rowid);
		console.log("createTable2 identification:" + identification);
		if (identification != "") {
			option = "?identification=" + identification;
		}
	}

	var rowid = jQuery("#tbl_jqgrid02").getGridParam("selrow");
	var accountType = jQuery('#sel_part01 option:selected').val();

	//テーブル生成
	jQuery("#tbl_jqgrid02").GridUnload();
	jQuery("#tbl_jqgrid02").jqGrid({
		url					: "partmanager" + option,
		cellurl				: "partmanager",
		datatype			: "xml",
		caption				: "品目",
		colNames			: colNames2,
		colModel			: colModels2,
		rowNum				: 100,
		height				: tblHeight2,
		width				: tblWidth2,
		pager				: "#div_jqgrid_navi02",
		rownumbers			: true,
		viewrecords			: true,
		multiselect			: false,
		shrinkToFit			: false,
		treeGrid			: false,
		cellEdit			: false,
		gridComplete		: function() {
			if (currentAccountType == accountType && rowid != null){
				jQuery("#tbl_jqgrid02").setSelection(rowid, true);
			}
			if (bolSetFrozenColumns) {
				jQuery("#tbl_jqgrid02").jqGrid('setFrozenColumns');
				bolSetFrozenColumns = false;
			}
		},
		onSelectRow			: function(rowid) {
			console.log("createTable2 onSelectRowTreeGrid");
			console.log("createTable2 onSelectRowTreeGrid rowid:" + rowid);
			updateButtonState(false);
		},
		ondblClickRow		: function(rowid){
			onClickButton02();
		},
		onSortCol			: function(index, colindex, sortorder) {
			console.log("createTable2 onSortCol index:" + index);
			console.log("createTable2 onSortCol colindex:" + colindex);
			console.log("createTable2 onSortCol sortorder:" + sortorder);
		},
		beforeEditCell		: function(rowid, cellname, value, iRow, iCol){
			updateButtonState(true);
		},
		afterEditCell		: function(rowid, cellname, value, iRow, iCol){

		},
		beforeSubmitCell	: function(rowid, cellname, value ,iRow, iCol) {
			updateButtonState(false);
		},
		afterSubmitCell		: function(response, rowid, cellname, value, iRow, iCol) {
			var responseText = response.responseText;
			console.log("createTable2 afterSubmitCell serverresponse:" + responseText);
			console.log("createTable2 afterSubmitCell rowid:" + rowid);
			console.log("createTable2 afterSubmitCell cellname:" + cellname);
			console.log("createTable2 afterSubmitCell value:" + value);
			console.log("createTable2 afterSubmitCell iRow:" + iRow);
			console.log("createTable2 afterSubmitCell iCol:" + iCol);

			if ( responseText == "" ) {
				return [false, ""];
			}

			if ( cellname == "NAME") {
				jQuery("#tbl_jqgrid01").setCell(rowid, cellname, value, "", "");
			}

			var data = new Array();
			var responseTextArray = responseText.split(",");
			for (var ii = 0; ii < responseTextArray.length; ++ii) {
				var elem1 = responseTextArray[ii];
				var elem2 = elem1.split("=");
				var key = elem2[0];
				var value = elem2[1];
				data[key] = value;
			}
			jQuery("#tbl_jqgrid02").setRowData(rowid, data);

			return [true, ""];
		},
		beforeSaveCell		: function(rowid, cellname, value ,iRow, iCol) {
			updateButtonState(false);
		},
		afterSaveCell		: function(rowid, cellname, value, iRow, iCol) {
			updateButtonState(false);
			console.log("createTable2 afterSaveCell rowid:" + rowid);
			console.log("createTable2 afterSaveCell cellname:" + cellname);
			console.log("createTable2 afterSaveCell value:" + value);
			console.log("createTable2 afterSaveCell iRow:" + iRow);
			console.log("createTable2 afterSaveCell iCol:" + iCol);
		}
	});//.navGrid('#div_jqgrid_navi02',{add: false, edit: false, del: false, refresh: false, search: false});
}

/**
 *
 * @param disabled
 */
function updateButtonState(disabled) {

	console.log("updateButtonState");
	console.log("updateButtonState disabled:" + disabled);

	if ( disabled ) {
		$('#sel_part01').attr('disabled', disabled);
		$('#btn_part01').attr('disabled', disabled);
		$('#btn_part02').attr('disabled', disabled);
		$('#btn_part03').attr('disabled', disabled);
		$('#btn_part04').attr('disabled', disabled);
		$('#btn_part05').attr('disabled', disabled);
		$('#btn_part06').attr('disabled', disabled);
		$('#btn_part07').attr('disabled', disabled);
	}
	else {
		var rowid1 = jQuery("#tbl_jqgrid01").getGridParam("selrow");
		var rowid2 = jQuery("#tbl_jqgrid02").getGridParam("selrow");

		$('#sel_part01').attr('disabled', disabled);
		if ( rowid1 == null ) {
			$('#btn_part01').attr('disabled', true);
		}
		else {
			$('#btn_part01').attr('disabled', false);
		}

		if ( rowid2 == null ) {
			disabled = true;
		}
		else {
			disabled = false;
		}

		$('#btn_part02').attr('disabled', disabled);
		$('#btn_part03').attr('disabled', disabled);
		$('#btn_part04').attr('disabled', disabled);
		$('#btn_part05').attr('disabled', disabled);
		$('#btn_part06').attr('disabled', disabled);
		$('#btn_part07').attr('disabled', disabled);
	}
}

/**
 *
 * @param rowid
 */
function onClickButton01() {

	console.log("onClickButton01");

	var rowid = jQuery("#tbl_jqgrid01").getGridParam("selrow");
	if ( rowid == null ) {
		return;
	}

	var identification = jQuery("#tbl_jqgrid01").getCell(rowid, "IDENTIFICATION");
	if ( identification == null ) {
		return;
	}

	jQuery("#tbl_jqgrid02").jqGrid('editGridRow',"new", {
		url					: "partmanager",
		editData			: {"IDENTIFICATION":identification},
		mtype				: "POST",
		height				: "auto",
		modal				: true,
		addCaption			: "追加",
		bSubmit				: "保存",
		bCancel				: "キャンセル",
		addedrow			: "last",
		closeAfterAdd		: true,
		clearAfterAdd		: false,
		reloadAfterSubmit	: false,
		afterComplete		: function(response, postdata, formid) {
			// 追加が完了した時のイベント処理
			console.log("onClickButton01 afterComplete");

			var responseText = response.responseText;
			console.log("onClickButton01 afterComplete response:" + responseText);

			if ( responseText == "" ) {
				return;
			}

			var data = new Array();
			var responseTextArray = responseText.split(",");
			for (var ii = 0; ii < responseTextArray.length; ++ii) {
				var elem1 = responseTextArray[ii];
				var elem2 = elem1.split("=");
				var key = elem2[0];
				var value = elem2[1];
				data[key] = value;
			}

			jQuery("#tbl_jqgrid02").setRowData(postdata['id'], data);
		}
	});
}

/**
 *
 * @param rowid
 */
function onClickButton02() {

	console.log("onClickButton02");

	var rowid = jQuery("#tbl_jqgrid02").getGridParam("selrow");
	if ( rowid == null ) {
		return;
	}

	var identification = jQuery("#tbl_jqgrid02").getCell(rowid, "IDENTIFICATION");
	if ( identification == null ) {
		return;
	}

	jQuery("#tbl_jqgrid02").jqGrid('editGridRow', rowid, {
		url					: "partmanager",
		editData			: {"IDENTIFICATION":identification},
		mtype				: "POST",
		height				: "auto",
		modal				: true,
		editCaption			: "変更",
		bSubmit				: "保存",
		bCancel				: "キャンセル",
		closeAfterEdit		: true,
		reloadAfterSubmit	: false,
		beforeSubmit		: function(postdata, formid) {
			// 追加が完了した時のイベント処理
			console.log("beforeSubmit");
	    	return [true, ""];
		},
		afterComplete		: function(response, postdata, formid) {
			console.log("onClickButton02 afterComplete");

			var responseText = response.responseText;
			console.log("onClickButton02 afterComplete response:" + responseText);

			var data = new Array();
			var responseTextArray = responseText.split(",");
			for (var ii = 0; ii < responseTextArray.length; ++ii) {
				var elem1 = responseTextArray[ii];
				var elem2 = elem1.split("=");
				var key = elem2[0];
				var value = elem2[1];
				data[key] = value;
			}
			jQuery("#tbl_jqgrid02").setRowData(rowid, data);

			console.log("onClickButton02 afterComplete NAME:" + postdata["NAME"]);
			jQuery("#tbl_jqgrid01").setCell(rowid, "NAME", postdata["NAME"], "", "");
		}
	});
}

/**
 *
 * @param rowid
 */
function onClickButton03() {

	console.log("onClickButton03");

	var rowid = jQuery("#tbl_jqgrid02").getGridParam("selrow");
	if ( rowid == null ) {
		return;
	}

	var identification = jQuery("#tbl_jqgrid02").getCell(rowid, "IDENTIFICATION");
	if ( identification == null ) {
		return;
	}

	jQuery("#tbl_jqgrid02").jqGrid('delGridRow', rowid, {
		url					: "partmanager",
		delData				: {"IDENTIFICATION":identification},
		mtype				: "POST",
		height				: "auto",
		modal				: true,
		caption				: "削除",
		bSubmit				: "削除",
		bCancel				: "キャンセル",
		closeAfterEdit		: true,
		reloadAfterSubmit	: true,
		afterSubmit			: function(response, postdata) {
			// 削除が完了した時のイベント処理
			console.log("onClickButton03 onclickSubmit");
			console.log("onClickButton03 onclickSubmit response:" + response.responseText);
			if (response.responseText != "") {
		    	return [false, response.responseText];
			}
	    	return [true, ""];
		}
	});
}

/**
 *
 */
function onClickButton04() {

	console.log("onClickButton04");

	var rowid_p = jQuery("#tbl_jqgrid01").getGridParam("selrow");
	if ( rowid_p == null ) {
		return;
	}

	var rowid_c = jQuery("#tbl_jqgrid02").getGridParam("selrow");
	if ( rowid_c == null ) {
		return;
	}

	$.ajax({
		url: "partmanager",
	    type: "POST",
		cache : false,
		data: {"oper":"move_row_top", "rowid_p":rowid_p, "rowid_c":rowid_c},
		success: function(data, status, xhr) {
			console.log("onClickButton04 success");
			onReloadAction();
		},
		error: function(xhr, status, error) {
			// 通信失敗時の処理
			return;
		},
		complete: function(xhr, status) {
			// 通信完了時の処理
			return;
	    }
	});
}

/**
 *
 */
function onClickButton05() {

	console.log("onClickButton05");

	var rowid_p = jQuery("#tbl_jqgrid01").getGridParam("selrow");
	if ( rowid_p == null ) {
		return;
	}

	var rowid_c = jQuery("#tbl_jqgrid02").getGridParam("selrow");
	if ( rowid_c == null ) {
		return;
	}

	$.ajax({
		url: "partmanager",
	    type: "POST",
		cache : false,
		data: {"oper":"move_row_up", "rowid_p":rowid_p, "rowid_c":rowid_c},
		success: function(data, status, xhr) {
			console.log("onClickButton05 success");
			onReloadAction();
		},
		error: function(xhr, status, error) {
			// 通信失敗時の処理
			return;
		},
		complete: function(xhr, status) {
			// 通信完了時の処理
			return;
	    }
	});

}

/**
*
*/
function onClickButton06() {

	console.log("onClickButton06");

	var rowid_p = jQuery("#tbl_jqgrid01").getGridParam("selrow");
	if ( rowid_p == null ) {
		return;
	}

	var rowid_c = jQuery("#tbl_jqgrid02").getGridParam("selrow");
	if ( rowid_c == null ) {
		return;
	}

	$.ajax({
		url: "partmanager",
	    type: "POST",
		cache : false,
		data: {"oper":"move_row_down", "rowid_p":rowid_p, "rowid_c":rowid_c},
		success: function(data, status, xhr) {
			console.log("onClickButton06 success");
			onReloadAction();
		},
		error: function(xhr, status, error) {
			// 通信失敗時の処理
			return;
		},
		complete: function(xhr, status) {
			// 通信完了時の処理
			return;
	    }
	});

}

/**
*
*/
function onClickButton07() {

	console.log("onClickButton07");

	var rowid_p = jQuery("#tbl_jqgrid01").getGridParam("selrow");
	if ( rowid_p == null ) {
		return;
	}

	var rowid_c = jQuery("#tbl_jqgrid02").getGridParam("selrow");
	if ( rowid_c == null ) {
		return;
	}

	$.ajax({
		url: "partmanager",
	    type: "POST",
		cache : false,
		data: {"oper":"move_row_bottom", "rowid_p":rowid_p, "rowid_c":rowid_c},
		success: function(data, status, xhr) {
			console.log("onClickButton07 success");
			onReloadAction();
		},
		error: function(xhr, status, error) {
			// 通信失敗時の処理
			return;
		},
		complete: function(xhr, status) {
			// 通信完了時の処理
			return;
	    }
	});
}

