package systemModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import model.Entity;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ColumnMaster extends Entity {

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 */
	public ColumnMaster(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values) {
		super(db, keys,values, "COLUMN_MASTER");
	}


	/**
	 *
	 * @return
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public ColumnSetting getColumnSetting(String personId) throws SQLException, ClassNotFoundException, IOException {

		ClassColumnSetting clsColumnSetting = new ClassColumnSetting(m_db);

		String condition = "";
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		condition = "SUPER_IDENTIFICATION = ? and PERSON_NUMBER = ?";
		conditionValues.add(identification());
		conditionValues.add(personId);

		ArrayList<ColumnSetting> objects = clsColumnSetting.select(condition, conditionValues);

		return objects.get(0);
	}
}
