/**
 *
 */
package meta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

/**
 *
 * @author 無糖ブラック
 *
 */
public class MetaFactory {

	/**
	 *
	 */
	static MetaFactory m_metaFactory = null;

	/**
	 *
	 */
	private Hashtable<String, ClassMetaObject> mapClassMetaObject;

	/**
	 *
	 */
	private MetaFactory() {
		mapClassMetaObject = new Hashtable<String, ClassMetaObject>();
	}

	/**
	 *
	 * @return
	 */
	public static MetaFactory getMetaFactory() {
		if ( m_metaFactory == null ) {
			m_metaFactory = new MetaFactory();
		}
		return m_metaFactory;
	}

	/**
	 *
	 * @param path
	 * @return
	 * @throws IOException
	 */
	public int init(String className, String path, String path2) throws IOException {

		String delimiter = "";
		ArrayList<String> columnNames = new ArrayList<String>();
		if ( className.equals("MetaColumn") ) {
			delimiter = "\t";
			columnNames.add("TABLE_VIEW_NAME");
			columnNames.add("TABLE_ID");
			columnNames.add("COLUMN_VIEW_NAME");
			columnNames.add("COLUMN_ID");
			columnNames.add("COLUMN_TYPE");
			columnNames.add("COLUMN_LENGTH");
			columnNames.add("COLUMN_DECIMAL");
			columnNames.add("COLUMN_PK");
			columnNames.add("COLUMN_NOT_NULL");
			columnNames.add("COLUMN_UNIQUE");
			columnNames.add("COLUMN_FK");
			columnNames.add("COLUMN_AUTO_INCREMENT");
			columnNames.add("COLUMN_DEFALT");
			columnNames.add("COLUMN_REMARK");

			ClassMetaColumn object = new ClassMetaColumn(path, path2, delimiter, columnNames);
			object.init();
			mapClassMetaObject.put(className, object);
		}

		return 0;
	}

	/**
	 *
	 * @param type
	 * @return
	 */
	public ClassMetaObject getClassMetaObject(String className) {
		return mapClassMetaObject.get(className);
	}
}
