/**
 *
 */
package meta;

import java.util.ArrayList;


/**
 *
 * @author 無糖ブラック
 *
 */
public class MetaColumn extends MetaObject {

	/**
	 *
	 * @param keys
	 * @param values
	 */
	public MetaColumn(ArrayList<String> keys, ArrayList<String> values) {
		super(keys, values);

		for( int ii = 0; ii < keys.size(); ++ii ) {
			String key = keys.get(ii);
			key = key.toUpperCase();
			String value = values.get(ii);
			if (value == null) {
				value = "";
			}
			value = value.trim();

			if (key.equals("COLUMN_PK") || key.equals("COLUMN_NOT_NULL") || key.equals("COLUMN_UNIQUE")) {
				if (value.equals("○")) {
					value = "TRUE";
				}
				else {
					value = "FALSE";
				}
			}

			if( key.equals("COLUMN_REMARK") ) {
				String columnRemarks[] = value.split(",");
				for (int jj = 0; jj < columnRemarks.length; ++jj) {
					String columnRemark = columnRemarks[jj];
					columnRemark = columnRemark.toUpperCase();
					properties.put(columnRemark, "TRUE");
				}
			}
			properties.put(key, value);
		}
	}

}
