/**
 *
 */
package control;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import model.DecoratedEntity;
import model.NavigationItem;
import objectModel.Account;
import objectModel.AccountPart;
import objectModel.ClassAccount;
import objectModel.ClassPart;
import objectModel.Part;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import systemModel.ClassColumnMaster;
import systemModel.ColumnMaster;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import common.DBAccessWrapper;
import common.Environment;

/**
 *
 * @author 無糖ブラック
 *
 */
public class PartManager extends ChokomaroHttpServlet {

	/**
	 *
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doGet(request, response);

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_identification = request.getParameter("identification");
		if ( in_identification != null ) {
			navigatePart(request, response);
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void navigatePart(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_userid = (String)session.getAttribute("userid");
		if(in_userid == null) {
			logger.info("セッションにユーザIDが設定されていません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		//jqgridパラメータ
		//http://localhost:8080/chokomaro/accountmanager?identificaton=3&_search=false&nd=1397348047107&rows=100&page=1&sidx=%E5%90%8D%E7%A7%B0&sord=asc

		String in_search = request.getParameter("_search");
		if ( in_search == null ) {
			in_search = "";
		}

		String in_nd = request.getParameter("nd");
		if ( in_nd == null ) {
			in_nd = "";
		}

		String in_rows = request.getParameter("rows");
		if ( in_rows == null ) {
			in_rows = "";
		}

		String in_page = request.getParameter("page");
		if ( in_page == null ) {
			in_page = "";
		}

		String in_sidx = request.getParameter("sidx");
		if ( in_sidx == null ) {
			in_sidx = "";
		}

		String in_sord = request.getParameter("sord");
		if ( in_sord == null ) {
			in_sord = "";
		}

		//jqgrid追加パラメータ
		String in_identification = request.getParameter("identification");
		if ( in_identification == null ) {
			in_identification = "";
		}

		String in_dummy = request.getParameter("dummy");
		if ( in_dummy == null ) {
			in_dummy = "";
		}
		else {
			in_dummy = in_dummy.toUpperCase();
		}

		String[] columns = null;
		String in_columns = request.getParameter("columns");
		if(in_columns != null) {
			columns = in_columns.split(",");
		}

		String conditionMaster = "";
		String conditionSetting = "";
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		conditionMaster = "self.TABLE_ID = ?";
		conditionSetting = "self.PERSON_NUMBER = ?";
		conditionValues.clear();
		conditionValues.add("PART");
		conditionValues.add(in_userid);

		DBAccessWrapper db = new DBAccessWrapper(env, in_userid);

		try {

			db.startTransaction();
			ClassColumnMaster clsColumnMaster = new ClassColumnMaster(db);
			ArrayList<DecoratedEntity> objects = clsColumnMaster.selectWithColumnSetting(conditionMaster, conditionSetting, conditionValues);

			//ソートインデックスの置換
			if ( !in_sidx.isEmpty() ) {
				Iterator<DecoratedEntity> itrColumns = objects.iterator();
				while (itrColumns.hasNext()) {
					DecoratedEntity decoratedEntity = itrColumns.next();

					ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
					//ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

					String columnViewVame = columnMaster.getProperty("COLUMN_VIEW_NAME");
					if ( columnViewVame.equals(in_sidx) ) {
						in_sidx = columnMaster.getProperty("COLUMN_ID");
						break;
					}
				}
			}

			String condition = "";
			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_identification);

			ArrayList<Account> accounts;
			ClassAccount clsAccount = new ClassAccount(db);
			accounts = clsAccount.select(condition, conditionValues);
			if ( accounts.size() == 0 ) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}
			Account account = accounts.get(0);

			// XML作成
			DocumentBuilder documentBuilder = null;
			documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = documentBuilder.newDocument();

			Element elem_rows = document.createElement("rows");
			document.appendChild(elem_rows);

			ArrayList<String> sortOrders = null;
			if (!in_sidx.isEmpty()) {
				sortOrders = new ArrayList<String>();
				String sortOrder = "PART.";
				sortOrder += in_sidx;
				sortOrder += " ";
				sortOrder += in_sord;
				sortOrders.add(sortOrder);
			}

			if ( in_dummy.equals("TRUE") ) {

				ArrayList<String> keys = new ArrayList<String>();
				ArrayList<String> values = new ArrayList<String>();

				Iterator<DecoratedEntity> itrColumns = objects.iterator();
				while (itrColumns.hasNext()) {
					DecoratedEntity decoratedEntity = itrColumns.next();

					ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
					//ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

					if ( columns != null ) {
						boolean isSkip = true;
						for (int ii = 0; ii < columns.length; ++ii) {
							String columnId1 = columns[ii];
							String columnId2 = columnMaster.getProperty("COLUMN_ID");
							if ( columnId1.equals(columnId2) ) {
								isSkip = false;
								break;
							}
						}
						if ( isSkip ) {
							continue;
						}
					}

					String columnId = columnMaster.getProperty("COLUMN_ID");
					keys.add(columnId);
					values.add("");
				}

				Part dummyPart = new Part(db, keys, values);
				createXml(document, elem_rows, dummyPart, objects, columns);
			}

			ArrayList<NavigationItem> navigationItems = account.navigatePart(sortOrders);

			Iterator<NavigationItem> itrNavigationItem = navigationItems.iterator();
			while (itrNavigationItem.hasNext()) {

				NavigationItem navigationItem = itrNavigationItem.next();
				//Account srcAccount = (Account) navigationItem.source;
				Part dstPart = (Part) navigationItem.destination;

				createXml(document, elem_rows, dstPart, objects, columns);
			}

			db.commit();

			// XML出力
			TransformerFactory tf = TransformerFactoryImpl.newInstance();
			tf.setAttribute(TransformerFactoryImpl.INDENT_NUMBER, "2");

			Transformer transformer = tf.newTransformer();
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");

			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);

			DOMSource source = new DOMSource(document);
			transformer.transform(source, result);

			response.getWriter().println(writer.toString());

		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param document
	 * @param elem_rows
	 * @param account
	 * @param objects
	 * @param columns
	 * @param treeGrid
	 * @throws IOException
	 */
	private void createXml(Document document, Element elem_rows, Part part, ArrayList<DecoratedEntity> objects, String[] columns) throws IOException {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		Element elem_row = null;
		Element elem_cell = null;

		String identification = part.identification();
		elem_row = document.createElement("row");
		elem_row.setAttribute("id", identification);
		elem_rows.appendChild(elem_row);

		String cellString = "";
		Iterator<DecoratedEntity> itrColumns = objects.iterator();
		while (itrColumns.hasNext()) {
			DecoratedEntity decoratedEntity = itrColumns.next();

			ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
			//ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

			if ( columns != null ) {
				boolean isSkip = true;
				for (int ii = 0; ii < columns.length; ++ii) {
					String columnId1 = columns[ii];
					String columnId2 = columnMaster.getProperty("COLUMN_ID");
					if ( columnId1.equals(columnId2) ) {
						isSkip = false;
						break;
					}
				}
				if ( isSkip ) {
					continue;
				}
			}

			String columnId = columnMaster.getProperty("COLUMN_ID");
			cellString = part.getProperty(columnId);
			elem_cell = document.createElement("cell");
			elem_cell.appendChild(document.createTextNode(cellString));
			elem_row.appendChild(elem_cell);
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doPost(request, response);

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_userid = (String)session.getAttribute("userid");
		if(in_userid == null) {
			logger.info("セッションにユーザIDが設定されていません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_oper = request.getParameter("oper");
		if ( in_oper == null ) {
			String messageString = "パラメータ（oper）が設定されていません。";
			logger.info(messageString);
			return;
		}

		if ( in_oper.equals("add") ) {
			buildPart(request, response, in_userid);
		}
		else if ( in_oper.equals("edit") ) {
			modifyPart(request, response, in_userid);
		}
		else if ( in_oper.equals("del") ) {
			deletePart(request, response, in_userid);
		}
		else if ( in_oper.equals("move_row_top") ) {
			moveRowTop(request, response, in_userid);
		}
		else if ( in_oper.equals("move_row_up") ) {
			moveRowUp(request, response, in_userid);
		}
		else if ( in_oper.equals("move_row_down") ) {
			moveRowDown(request, response, in_userid);
		}
		else if ( in_oper.equals("move_row_bottom") ) {
			moveRowBottom(request, response, in_userid);
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void buildPart(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_identification = request.getParameter("IDENTIFICATION");
		if ( in_identification == null ) {
			String messageString = "パラメータ（IDENTIFICATION）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String in_tax_inclusive = request.getParameter("TAX_INCLUSIVE");
		if(in_tax_inclusive == null) {
			String messageString = "パラメータ（TAX_INCLUSIVE）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String in_price = request.getParameter("PRICE");
		if(in_price == null) {
			String messageString = "パラメータ（PRICE）が設定されていません。";
			logger.info(messageString);
			return;
		}
		if (in_price.isEmpty()) {
			in_price = "0";
		}

		ArrayList<String> insertParams = new ArrayList<String>();
		ArrayList<Object> insertValues  = new ArrayList<Object>();

		insertParams.clear();
		insertValues.clear();

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects("PART");
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			boolean columnEditable = Boolean.valueOf(metaColumn.getProperty("EDITABLE"));
			if ( columnEditable ) {
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String in_insertParam = request.getParameter(columnId);
				if ( in_insertParam == null || in_insertParam.isEmpty() ) {
					boolean columnNotNull = Boolean.valueOf(metaColumn.getProperty("COLUMN_NOT_NULL"));
					if ( columnNotNull ) {
						String messageString = "パラメータ（";
						messageString += columnId;
						messageString += "）が設定されていません。";
						logger.info(messageString);
						return;
					}
				}
				else {
					insertParams.add(columnId);
					insertValues.add(in_insertParam);
				}
			}
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();
			ArrayList<Account> accounts;
			Account account;

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_identification);
			accounts = clsAccount.select(condition, conditionValues);
			if ( accounts.size() == 0 ) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}

			account = accounts.get(0);

			//外税の場合、単価に税率を掛けた総額を求める。
			int amount = Integer.parseInt(in_price);
			if (in_tax_inclusive.equals("false")) {
				int consumption_tax_rate =  Integer.parseInt(account.getProperty("CONSUMPTION_TAX_RATE"));
				amount = amount + (amount * consumption_tax_rate)/100;
			}

			insertParams.add("AMOUNT");
			insertValues .add(String.valueOf(amount));

			ClassPart clsPart = new ClassPart(db);

			//品目コード最大値取得
			String prefix = "PT";
			//String condition = "";
			ArrayList<String> selectParams = new ArrayList<String>();
			//ArrayList<Object> conditionValues = new ArrayList<Object>();

			selectParams.clear();
			selectParams.add("MAX(PART_NUMBER) AS PART_NUMBER");
			condition = "PART_NUMBER LIKE ?";
			conditionValues.clear();
			conditionValues.add(prefix + "%");

			int intMaxOfPartnerNumber = 0;
			ArrayList<ArrayList<String>> maxValues = clsPart.select(selectParams, condition, conditionValues);
			String strMaxOfAccountNumber = maxValues.get(0).get(0);
			if ( strMaxOfAccountNumber != null) {
				String strMaxOfAccountNumberBody = strMaxOfAccountNumber.substring(prefix.length(), strMaxOfAccountNumber.length());
				intMaxOfPartnerNumber = Integer.parseInt(strMaxOfAccountNumberBody);
			}
			++intMaxOfPartnerNumber;
			strMaxOfAccountNumber = String.format("%s%07d", prefix, intMaxOfPartnerNumber);

			//追加パラメータ設定
			insertParams.add("PART_NUMBER");
			insertValues.add(strMaxOfAccountNumber);

			Part newPart = clsPart.create(insertParams, insertValues);
			account.setAssociation(newPart, userid);

			db.commit();

			String delimiter = "";
			StringBuffer responseText = new StringBuffer();
			for (int ii = 0; ii < metaColumns.size(); ++ii) {
				MetaColumn metaColumn = metaColumns.get(ii);
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String value = newPart.getProperty(columnId);
				responseText.append(delimiter);
				responseText.append(columnId);
				responseText.append("=");
				responseText.append(value);
				delimiter = ",";
			}

			//登録結果出力
			response.getWriter().write(responseText.toString());

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public void modifyPart(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_identification = request.getParameter("IDENTIFICATION");
		if ( in_identification == null ) {
			String messageString = "パラメータ（IDENTIFICATION）が設定されていません。";
			logger.info(messageString);
			return;
		}

		ArrayList<String> updateParams = new ArrayList<String>();
		ArrayList<Object> updateValues  = new ArrayList<Object>();

		updateParams.clear();
		updateValues.clear();

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects("PART");
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			boolean columnEditable = Boolean.valueOf(metaColumn.getProperty("EDITABLE"));
			if ( columnEditable ) {
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String in_updateParam = request.getParameter(columnId);
				if ( in_updateParam != null && !in_updateParam.isEmpty() ) {
					updateParams.add(columnId);
					updateValues.add(in_updateParam);
				}
			}
		}

		String in_price = request.getParameter("PRICE");
		String in_tax_inclusive = request.getParameter("TAX_INCLUSIVE");

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();
			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_identification);

			ArrayList<Part> parts;
			ClassPart clsPart = new ClassPart(db);
			parts = clsPart.select(condition, conditionValues);
			if ( parts.size() == 0 ) {
				db.rollback();

				String messageString = "品目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}

			Part part = parts.get(0);

			ArrayList<String> inSortParams = null;
			ArrayList<NavigationItem> naviItemSet = part.navigateAccount(inSortParams);
			if ( naviItemSet.size() == 0 ) {
				db.rollback();

				String messageString = "勘定科目のナビゲートに失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}

			//勘定科目
			NavigationItem naviItem = naviItemSet.get(0);
			Account account = (Account)naviItem.destination;

			//外税の場合、単価に税率を掛けた総額を求める。
			int amount = Integer.parseInt(in_price);
			if (in_tax_inclusive != null && in_tax_inclusive.equals("FALSE")) {
				int consumption_tax_rate =  Integer.parseInt(account.getProperty("CONSUMPTION_TAX_RATE"));
				amount = amount + (amount * consumption_tax_rate)/100;
			}
			updateParams.add("AMOUNT");
			updateValues .add(String.valueOf(amount));

			ArrayList<Part> parts1 = clsPart.select(condition, conditionValues);
			if ( parts1.size() == 0 ) {
				db.rollback();

				String messageString = "品目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}
			Part part1 = parts1.get(0);

			int result = clsPart.update(updateParams, updateValues, condition, conditionValues);
			if ( result < 0 ) {
				db.rollback();

				String messageString = "品目の更新に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}

			ArrayList<Part> parts2 = clsPart.select(condition, conditionValues);
			if ( parts2.size() == 0 ) {
				db.rollback();

				String messageString = "品目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}
			Part part2 = parts2.get(0);

			db.commit();

			String delimiter = "";
			StringBuffer responseText = new StringBuffer();
			for (int ii = 0; ii < metaColumns.size(); ++ii) {
				MetaColumn metaColumn = metaColumns.get(ii);
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String value1 = part1.getProperty(columnId);
				String value2 = part2.getProperty(columnId);
				if ( !value1.equals(value2) ) {
					responseText.append(delimiter);
					responseText.append(columnId);
					responseText.append("=");
					responseText.append(value2);
					delimiter = ",";
				}
			}

			//登録結果出力
			response.getWriter().write(responseText.toString());

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void deletePart(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_identification = request.getParameter("IDENTIFICATION");
		if ( in_identification == null ) {
			String messageString = "パラメータ（IDENTIFICATION）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassPart clsPart = new ClassPart(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_identification);

			ArrayList<Part> parts;
			parts = clsPart.select(condition, conditionValues);
			if ( parts.size() == 0 ) {
				db.rollback();

				String messageString = "品目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}

			Part part;
			part = parts.get(0);
			int result = part.delete();

			if ( result < 0 ) {
				db.rollback();

				String messageString = "品目の削除に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void moveRowTop(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_rowid_p = request.getParameter("rowid_p");
		if ( in_rowid_p == null ) {
			String messageString = "パラメータ（rowid_p）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String rowid_c = request.getParameter("rowid_c");
		if ( rowid_c == null ) {
			String messageString = "パラメータ（rowid_c）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_rowid_p);

			int result = 0;
			ArrayList<Account> accounts;
			accounts = clsAccount.select(condition, conditionValues);
			if (accounts.size() == 0) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_rowid_p;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}

			Account account = accounts.get(0);

			ArrayList<String> inSortParams = null;
			ArrayList<NavigationItem> naviItemSet = account.navigatePart(inSortParams);

			boolean isFound = false;

			Iterator<NavigationItem> itrNaviItem = naviItemSet.iterator();
			while(itrNaviItem.hasNext()) {
				NavigationItem naviItem = itrNaviItem.next();

				//品目
				Part part = (Part)naviItem.destination;

				//勘定科目品目関連
				AccountPart accountPart = (AccountPart)naviItem.relation;

				String identification_c = part.identification();
				if ( identification_c.equals(rowid_c)) {
					result = accountPart.setProperty("STRUCT_ORDER", "1");
					isFound = true;
				}
				else {
					if ( isFound ) {
						break;
					}
					else {
						String strStructOrder = accountPart.getProperty("STRUCT_ORDER");
						int intStructOrder = Integer.parseInt(strStructOrder);
						++intStructOrder;
						result = accountPart.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
						if ( result < 0 ) {
							String messageString = "品目の順序変更に失敗しました。品目名称:" + part.getProperty("NAME");
							logger.warning(messageString);
							response.getWriter().write(messageString);
							break;
						}
					}
				}
			}

			if ( result < 0 ) {
				db.rollback();
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void moveRowUp(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_rowid_p = request.getParameter("rowid_p");
		if ( in_rowid_p == null ) {
			String messageString = "パラメータ（rowid_p）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String rowid_c = request.getParameter("rowid_c");
		if ( rowid_c == null ) {
			String messageString = "パラメータ（rowid_c）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_rowid_p);

			int result = 0;
			ArrayList<Account> accounts;
			accounts = clsAccount.select(condition, conditionValues);
			if (accounts.size() == 0) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_rowid_p;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}
			Account account = accounts.get(0);

			ArrayList<String> inSortParams = null;
			ArrayList<NavigationItem> naviItemSet = account.navigatePart(inSortParams);

			AccountPart lastAccountPart = null;

			Iterator<NavigationItem> itrNaviItem = naviItemSet.iterator();
			while(itrNaviItem.hasNext()) {
				NavigationItem naviItem = itrNaviItem.next();

				//品目
				Part part = (Part)naviItem.destination;

				//勘定科目品目関連
				AccountPart accountPart = (AccountPart)naviItem.relation;

				String identification_c = part.identification();
				if ( identification_c.equals(rowid_c)) {
					String strStructOrder = accountPart.getProperty("STRUCT_ORDER");
					int intStructOrder = Integer.parseInt(strStructOrder);
					if (intStructOrder == 1) {
						break;
					}

					--intStructOrder;
					result = accountPart.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
					if ( result < 0 ) {
						String messageString = "品目の順序変更に失敗しました。品目名称:" + part.getProperty("NAME");
						logger.warning(messageString);
						response.getWriter().write(messageString);
						break;
					}

					strStructOrder = lastAccountPart.getProperty("STRUCT_ORDER");
					intStructOrder = Integer.parseInt(strStructOrder);
					++intStructOrder;
					result = lastAccountPart.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
					if ( result < 0 ) {
						String messageString = "品目の順序変更に失敗しました。品目名称:" + part.getProperty("NAME");
						logger.warning(messageString);
						response.getWriter().write(messageString);
						break;
					}

					break;
				}
				else {
					lastAccountPart = accountPart;
				}
			}

			if ( result < 0 ) {
				db.rollback();
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void moveRowDown(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_rowid_p = request.getParameter("rowid_p");
		if ( in_rowid_p == null ) {
			String messageString = "パラメータ（rowid_p）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String rowid_c = request.getParameter("rowid_c");
		if ( rowid_c == null ) {
			String messageString = "パラメータ（rowid_c）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_rowid_p);

			int result = 0;
			ArrayList<Account> accounts;
			accounts = clsAccount.select(condition, conditionValues);
			if (accounts.size() == 0) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_rowid_p;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}
			Account account = accounts.get(0);

			ArrayList<String> inSortParams = null;
			ArrayList<NavigationItem> naviItemSet = account.navigatePart(inSortParams);

			boolean isFound = false;

			Iterator<NavigationItem> itrNaviItem = naviItemSet.iterator();
			while(itrNaviItem.hasNext()) {
				NavigationItem naviItem = itrNaviItem.next();

				//品目
				Part part = (Part)naviItem.destination;

				//勘定科目品目関連
				AccountPart accountPart = (AccountPart)naviItem.relation;

				String identification_c = part.identification();
				if ( identification_c.equals(rowid_c)) {

					String strStructOrder = accountPart.getProperty("STRUCT_ORDER");
					int intStructOrder = Integer.parseInt(strStructOrder);
					if (intStructOrder < naviItemSet.size()) {
						++intStructOrder;
					}

					result = accountPart.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
					if ( result < 0 ) {
						String messageString = "品目の順序変更に失敗しました。品目名称:" + part.getProperty("NAME");
						logger.warning(messageString);
						response.getWriter().write(messageString);
						break;
					}

					isFound = true;
				}
				else {
					if ( isFound ) {

						String strStructOrder = accountPart.getProperty("STRUCT_ORDER");
						int intStructOrder = Integer.parseInt(strStructOrder);
						if (intStructOrder > 1) {
							--intStructOrder;
						}

						result = accountPart.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
						if ( result < 0 ) {
							String messageString = "品目の順序変更に失敗しました。品目名称:" + part.getProperty("NAME");
							logger.warning(messageString);
							response.getWriter().write(messageString);
							break;
						}

						break;
					}
				}
			}

			if ( result < 0 ) {
				db.rollback();
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void moveRowBottom(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_rowid_p = request.getParameter("rowid_p");
		if ( in_rowid_p == null ) {
			String messageString = "パラメータ（rowid_p）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String rowid_c = request.getParameter("rowid_c");
		if ( rowid_c == null ) {
			String messageString = "パラメータ（rowid_c）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_rowid_p);

			int result = 0;
			ArrayList<Account> accounts;
			accounts = clsAccount.select(condition, conditionValues);
			if (accounts.size() == 0) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_rowid_p;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}
			Account account = accounts.get(0);

			ArrayList<String> inSortParams = null;
			ArrayList<NavigationItem> naviItemSet = account.navigatePart(inSortParams);

			boolean isFound = false;

			Iterator<NavigationItem> itrNaviItem = naviItemSet.iterator();
			while(itrNaviItem.hasNext()) {
				NavigationItem naviItem = itrNaviItem.next();

				//品目
				Part part = (Part)naviItem.destination;

				//勘定科目品目関連
				AccountPart accountPart = (AccountPart)naviItem.relation;

				String identification_c = part.identification();
				if ( identification_c.equals(rowid_c)) {
					result = accountPart.setProperty("STRUCT_ORDER", String.valueOf(naviItemSet.size()));
					isFound = true;
				}
				else {
					if ( isFound ) {

						String strStructOrder = accountPart.getProperty("STRUCT_ORDER");
						int intStructOrder = Integer.parseInt(strStructOrder);
						if (intStructOrder > 1) {
							--intStructOrder;
						}

						result = accountPart.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
						if ( result < 0 ) {
							String messageString = "品目の順序変更に失敗しました。品目名称:" + part.getProperty("NAME");
							logger.warning(messageString);
							response.getWriter().write(messageString);
							break;
						}
					}
				}
			}

			if ( result < 0 ) {
				db.rollback();
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}
}
