/**
 *
 */
package control;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import model.DecoratedEntity;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import systemModel.ClassColumnMaster;
import systemModel.ColumnMaster;
import systemModel.ColumnSetting;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import common.DBAccessWrapper;
import common.Environment;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ColumnManager extends ChokomaroHttpServlet {

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doGet(request, response);

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_userid = (String)session.getAttribute("userid");
		if(in_userid == null) {
			logger.info("セッションにユーザIDが設定されていません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_tableid = request.getParameter("tableid");
		if(in_tableid == null) {
			String messageString = "検索対象テーブルIDが設定されていません。";
			logger.info(messageString);
			response.getWriter().write(messageString);
			return;
		}

		String[] columns = null;
		String in_columns = request.getParameter("columns");
		if(in_columns != null) {
			columns = in_columns.split(",");
		}

		String in_key = request.getParameter("key");
		if(in_key == null) {
			in_key = "";
		}

		String conditionMaster = "";
		String conditionSetting = "";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		conditionMaster = "self.TABLE_ID = ?";
		conditionSetting = "self.PERSON_NUMBER = ?";
		conditionTypes.add("string");
		conditionTypes.add("string");
		conditionValues.add(in_tableid.toUpperCase());
		conditionValues.add(in_userid);

		DBAccessWrapper db = new DBAccessWrapper(env, in_userid);

		try {

			db.startTransaction();
			ClassColumnMaster clsColumnMaster = new ClassColumnMaster(db);
			ArrayList<DecoratedEntity> objects = clsColumnMaster.selectWithColumnSetting(conditionMaster, conditionSetting, conditionValues);
			db.commit();

			MetaFactory metaFactory = MetaFactory.getMetaFactory();
			ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
			ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
			ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects(in_tableid);

			// XML作成
			DocumentBuilder documentBuilder = null;
			documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = documentBuilder.newDocument();

			Element elem_rows = document.createElement("rows");
			document.appendChild(elem_rows);

			Iterator<DecoratedEntity> itr = objects.iterator();

			if (!in_key.isEmpty()) {

				while (itr.hasNext()) {

					DecoratedEntity decoratedEntity = itr.next();

					ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
					ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

					String nodeText = "";
					Element elem_row = null;
					Element elem_cell = null;

					String columnId1 = in_key;
					String columnId2 = columnMaster.getProperty("COLUMN_ID");
					if ( !columnId1.equals(columnId2) ) {
						continue;
					}

					elem_row = document.createElement("row");
					elem_row.setAttribute("id", columnMaster.identification());
					elem_rows.appendChild(elem_row);

					// 列表示名
					nodeText = columnMaster.getProperty("COLUMN_VIEW_NAME");
					elem_cell = document.createElement("COLUMN_VIEW_NAME");
					elem_cell.appendChild(document.createTextNode(nodeText));
					elem_row.appendChild(elem_cell);

					// 列名
					nodeText = "__KEY__";
					elem_cell = document.createElement("COLUMN_ID");
					elem_cell.appendChild(document.createTextNode(nodeText));
					elem_row.appendChild(elem_cell);

					// 型
					nodeText = columnMaster.getProperty("COLUMN_TYPE");
					elem_cell = document.createElement("COLUMN_TYPE");
					elem_cell.appendChild(document.createTextNode(nodeText));
					elem_row.appendChild(elem_cell);

					// 列幅
					nodeText = columnSetting.getProperty("WITDH");
					elem_cell = document.createElement("WITDH");
					elem_cell.appendChild(document.createTextNode(nodeText));
					elem_row.appendChild(elem_cell);

					// 表示/非表示
					nodeText = columnMaster.getProperty("COLUMN_DISPLAY");
					if ( nodeText.equals("TRUE") ) {
						nodeText = columnSetting.getProperty("DISPLAY");
					}
					elem_cell = document.createElement("COLUMN_DISPLAY");
					elem_cell.appendChild(document.createTextNode(nodeText));
					elem_row.appendChild(elem_cell);

					// 編集可否
					nodeText = "FALSE";
					elem_cell = document.createElement("COLUMN_EDITABLE");
					elem_cell.appendChild(document.createTextNode(nodeText));
					elem_row.appendChild(elem_cell);

					for (int ii = 0; ii < metaColumns.size(); ++ii) {
						MetaColumn metaColumn = metaColumns.get(ii);
						String columnId3 = metaColumn.getProperty("COLUMN_ID");
						if ( columnId2.equals(columnId3) ) {
							// NOT NULL
							nodeText = metaColumn.getProperty("COLUMN_NOT_NULL");
							elem_cell = document.createElement("COLUMN_NOT_NULL");
							elem_cell.appendChild(document.createTextNode(nodeText));
							elem_row.appendChild(elem_cell);
							break;
						}
					}

					break;
				}
			}

			itr = objects.iterator();
			while (itr.hasNext()) {
				DecoratedEntity decoratedEntity = itr.next();

				ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
				ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

				String nodeText = "";
				Element elem_row = null;
				Element elem_cell = null;

				if ( columns != null ) {
					boolean isSkip = true;
					for (int ii = 0; ii < columns.length; ++ii) {
						String columnId1 = columns[ii];
						String columnId2 = columnMaster.getProperty("COLUMN_ID");
						if ( columnId1.equals(columnId2) ) {
							isSkip = false;
							break;
						}
					}
					if ( isSkip ) {
						continue;
					}
				}

				elem_row = document.createElement("row");
				elem_row.setAttribute("id", columnMaster.identification());
				elem_rows.appendChild(elem_row);

				// 列表示名
				nodeText = columnMaster.getProperty("COLUMN_VIEW_NAME");
				elem_cell = document.createElement("COLUMN_VIEW_NAME");
				elem_cell.appendChild(document.createTextNode(nodeText));
				elem_row.appendChild(elem_cell);

				// 列名
				nodeText = columnMaster.getProperty("COLUMN_ID");
				elem_cell = document.createElement("COLUMN_ID");
				elem_cell.appendChild(document.createTextNode(nodeText));
				elem_row.appendChild(elem_cell);

				// 型
				nodeText = columnMaster.getProperty("COLUMN_TYPE");
				elem_cell = document.createElement("COLUMN_TYPE");
				elem_cell.appendChild(document.createTextNode(nodeText));
				elem_row.appendChild(elem_cell);

				// 列幅
				nodeText = columnSetting.getProperty("WITDH");
				elem_cell = document.createElement("WITDH");
				elem_cell.appendChild(document.createTextNode(nodeText));
				elem_row.appendChild(elem_cell);

				// 表示/非表示
				String columnId = columnMaster.getProperty("COLUMN_ID");
				if ( columnId.equals(in_key) ) {
					nodeText = "FALSE";
				}
				else {
					nodeText = columnMaster.getProperty("COLUMN_DISPLAY");
					if ( nodeText.equals("TRUE") ) {
						nodeText = columnSetting.getProperty("DISPLAY");
					}
				}
				elem_cell = document.createElement("COLUMN_DISPLAY");
				elem_cell.appendChild(document.createTextNode(nodeText));
				elem_row.appendChild(elem_cell);

				// 編集可否
				nodeText = columnMaster.getProperty("COLUMN_EDITABLE");
				elem_cell = document.createElement("COLUMN_EDITABLE");
				elem_cell.appendChild(document.createTextNode(nodeText));
				elem_row.appendChild(elem_cell);

				for (int ii = 0; ii < metaColumns.size(); ++ii) {
					MetaColumn metaColumn = metaColumns.get(ii);
					String columnId1 = columnMaster.getProperty("COLUMN_ID");
					String columnId2 = metaColumn.getProperty("COLUMN_ID");
					if ( columnId1.equals(columnId2) ) {
						// NOT NULL
						nodeText = metaColumn.getProperty("COLUMN_NOT_NULL");
						elem_cell = document.createElement("COLUMN_NOT_NULL");
						elem_cell.appendChild(document.createTextNode(nodeText));
						elem_row.appendChild(elem_cell);
						break;
					}
				}
			}

			// XML出力
			TransformerFactory tf = TransformerFactoryImpl.newInstance();
			tf.setAttribute(TransformerFactoryImpl.INDENT_NUMBER, "2");

			Transformer transformer = tf.newTransformer();
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");

			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);

			DOMSource source = new DOMSource(document);
			transformer.transform(source, result);

			response.getWriter().println(writer.toString());

		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		}

		logger.finest("END/NORMAL");
		return;
	}
}
