/**
 *
 */
package control;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import systemModel.ClassPerson;
import systemModel.Person;

import common.DBAccessWrapper;
import common.Environment;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Chokomaro extends ChokomaroHttpServlet {

	@Override
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doGet(request, response);

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);

		String in_application = "";
		String in_userid = "";

		//メンテナンスモード判定
		String in_setup = env.getParam("setup");

		if ( in_setup.equals("on") ) {
			//メンテナンスモード
			in_userid = "admin";
			in_application = "maintenance";

			session = request.getSession(true);
			session.setAttribute("setup", in_setup);
			session.setAttribute("application", in_application);
			session.setAttribute("userid", in_userid);

			logger.info("メンテナンスモードで起動します。メンテナンス画面を表示します。");
			String path = "./jsp/" + in_application + ".jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		//通常モード
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String setup = (String)session.getAttribute("setup");
		if ( setup != null && setup.equals("on") ) {
			session.invalidate();
			session = null;

			logger.info("メンテナンスモードが終了しました。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		in_userid = (String)session.getAttribute("userid");
		if ( in_userid == null || in_userid.isEmpty() ) {
			session.invalidate();
			session = null;

			logger.info("ログインしていません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		in_application = request.getParameter("application");
		if ( in_application != null && in_application.equals("logout") ) {
			session.invalidate();
			session = null;

			logger.info("ログアウトします。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		if ( in_application == null || in_application.isEmpty() ) {
			in_application = "home";
		}

		session.setAttribute("setup", setup);
		session.setAttribute("application", in_application);

		//遷移先パス設定
		String jspPath = "./jsp/" + in_application + ".jsp";
		String realPath = getServletContext().getRealPath(jspPath);
		File jspFile = new File(realPath);
		if ( !jspFile.exists() ) {
			logger.warning("指定されたJSPファイルがありません。:" + jspPath);
			jspPath = "./jsp/home.jsp";
		}
		RequestDispatcher rd = request.getRequestDispatcher(jspPath);
		rd.forward(request, response);

		logger.finest("END/NORMAL");
	}

	@Override
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doPost(request, response);

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_userid = request.getParameter("userid");
		if ( in_userid == null || in_userid.isEmpty() ) {
			String messageString = "ユーザーIDを入力してください。";
			logger.info(messageString);
			response.getWriter().write(messageString);
			return;
		}

		String in_password = request.getParameter("password");
		if ( in_password == null || in_userid.isEmpty() ) {
			String messageString = "パスワードを入力してください。";
			logger.info(messageString);
			response.getWriter().write(messageString);
			return;
		}

		//検索条件構築
		String condition = "";
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		condition = "person_number = ? and password = ?";
		conditionValues.add(in_userid);
		conditionValues.add(in_password);

		DBAccessWrapper db = new DBAccessWrapper(env, in_userid);
		ClassPerson clsPerson = new ClassPerson(db);
		ArrayList<Person> persons;

		try {
			db.startTransaction();
			persons = clsPerson.select(condition, conditionValues);
			db.commit();
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		}

		if ( persons.size() == 0 ) {
			String messageString = "ユーザIDが存在しないかパスワードが誤っています。";
			logger.warning(messageString + ": userid = " + in_userid);
			response.getWriter().write(messageString);
			return;
		}

		String in_application = "home";

		HttpSession session = request.getSession(true);
		session.setAttribute("application", in_application);
		session.setAttribute("userid", in_userid);

//		String jspPath = "./jsp/" + in_application + ".jsp";
//		RequestDispatcher rd = request.getRequestDispatcher(jspPath);
//		rd.forward(request, response);

		String messageString = "";
		response.getWriter().write(messageString);

		logger.finest("END/NORMAL");
	}
}
