/**
 *
 */
package control;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import model.DecoratedEntity;
import model.NavigationItem;
import objectModel.Account;
import objectModel.AccountStructure;
import objectModel.ClassAccount;
import objectModel.Part;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import systemModel.ClassColumnMaster;
import systemModel.ColumnMaster;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import common.DBAccessWrapper;
import common.Environment;

/**
 *
 * @author 無糖ブラック
 *
 */
public class AccountManager extends ChokomaroHttpServlet {

	/**
	 *
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doGet(request, response);

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		selectAccount(request, 	response);

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void selectAccount(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_userid = (String)session.getAttribute("userid");
		if(in_userid == null) {
			logger.info("セッションにユーザIDが設定されていません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		//jqgridパラメータ
		//http://localhost:8080/chokomaro/accountmanager?identificaton=3&_search=false&nd=1397348047107&rows=100&page=1&sidx=%E5%90%8D%E7%A7%B0&sord=asc

		String in_search = request.getParameter("_search");
		if ( in_search == null ) {
			in_search = "";
		}

		String in_nd = request.getParameter("nd");
		if ( in_nd == null ) {
			in_nd = "";
		}

		String in_rows = request.getParameter("rows");
		if ( in_rows == null ) {
			in_rows = "";
		}

		String in_page = request.getParameter("page");
		if ( in_page == null ) {
			in_page = "";
		}

		String in_sidx = request.getParameter("sidx");
		if ( in_sidx == null ) {
			in_sidx = "";
		}

		String in_sord = request.getParameter("sord");
		if ( in_sord == null ) {
			in_sord = "";
		}

		//jqgrid追加パラメータ
		String in_treeGrid = request.getParameter("treeGrid");
		if ( in_treeGrid == null ) {
			in_treeGrid = "false";
		}

		String in_accountType = request.getParameter("accountType");
		if ( in_accountType == null ) {
			in_accountType = "";
		}

		String in_identification = request.getParameter("identification");
		if ( in_identification == null ) {
			in_identification = "";
		}

		if ( in_accountType.isEmpty() && in_identification.isEmpty() ) {
			String messageString = "勘定科目分類と勘定科目が未選択です。";
			logger.info(messageString);
			return;
		}

		String[] columns = null;
		String in_columns = request.getParameter("columns");
		if(in_columns != null) {
			columns = in_columns.split(",");
		}

		String in_key = request.getParameter("key");
		if(in_key == null) {
			in_key = "";
		}

		String conditionMaster = "";
		String conditionSetting = "";
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		conditionMaster = "self.TABLE_ID = ?";
		conditionSetting = "self.PERSON_NUMBER = ?";
		conditionValues.clear();
		conditionValues.add("ACCOUNT");
		conditionValues.add(in_userid);

		DBAccessWrapper db = new DBAccessWrapper(env, in_userid);

		try {

			db.startTransaction();
			ClassColumnMaster clsColumnMaster = new ClassColumnMaster(db);
			ArrayList<DecoratedEntity> objects = clsColumnMaster.selectWithColumnSetting(conditionMaster, conditionSetting, conditionValues);

			//ソートインデックスの置換
			if ( !in_sidx.isEmpty() ) {
				Iterator<DecoratedEntity> itrColumns = objects.iterator();
				while (itrColumns.hasNext()) {
					DecoratedEntity decoratedEntity = itrColumns.next();

					ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
					//ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

					String columnViewVame = columnMaster.getProperty("COLUMN_VIEW_NAME");
					if ( columnViewVame.equals(in_sidx) ) {
						in_sidx = columnMaster.getProperty("COLUMN_ID");
						break;
					}
				}
			}

			String condition = "";
			if( in_identification == null || in_identification.isEmpty() ) {
				condition = "TOP_ACCOUNT = ? AND HAS_ACCOUNT = ? AND ACCOUNT_TYPE = ?";
				conditionValues.clear();
				conditionValues.add("true");
				conditionValues.add("true");
				conditionValues.add(in_accountType);
			}
			else {
				condition = "IDENTIFICATION = ?";
				conditionValues.clear();
				conditionValues.add(in_identification);
			}

			if ( !in_sidx.isEmpty() ) {
				condition += " ORDER BY ";
				condition += in_sidx;
				condition += " ";
				condition += in_sord;
			}

			ArrayList<Account> accounts;
			ClassAccount clsAccount = new ClassAccount(db);
			accounts = clsAccount.select(condition, conditionValues);

			// XML作成
			DocumentBuilder documentBuilder = null;
			documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = documentBuilder.newDocument();

			Element elem_rows = document.createElement("rows");
			document.appendChild(elem_rows);

			Iterator<Account> itrAccount = accounts.iterator();
			while (itrAccount.hasNext()) {
				Account account = itrAccount.next();

				if (in_treeGrid.equals("true")) {

					int level = 0;
					String parentIdentification = "";
					createXml(document, elem_rows, level, parentIdentification, account, objects, columns, in_treeGrid, in_key);
				}

				navigateAccount(document, elem_rows, account, objects, columns, in_treeGrid, in_sidx, in_sord, in_key);
			}
			db.commit();

			// XML出力
			TransformerFactory tf = TransformerFactoryImpl.newInstance();
			tf.setAttribute(TransformerFactoryImpl.INDENT_NUMBER, "2");

			Transformer transformer = tf.newTransformer();
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");

			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);

			DOMSource source = new DOMSource(document);
			transformer.transform(source, result);

			response.getWriter().println(writer.toString());

		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param document
	 * @param elem_rows
	 * @param account
	 * @param objects
	 * @param columns
	 * @param treeGrid
	 * @throws IOException
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	private void navigateAccount(Document document, Element elem_rows, Account account, ArrayList<DecoratedEntity> objects, String[] columns, String treeGrid, String sidx, String sord, String key) throws SQLException, ClassNotFoundException, IOException {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String lastParent = "";
		String lastChild = "";
		ArrayList<String> parents = new ArrayList<String>();

		String selectLevel  = "";
		if(treeGrid.equals("true")){
			selectLevel = "multi";
		}
		else {
			selectLevel = "single";
		}

		ArrayList<String> sortOrders = null;
		if (!sidx.isEmpty()) {
			sortOrders = new ArrayList<String>();
			String sortOrder = "ACCOUNT.";
			sortOrder += sidx;
			sortOrder += " ";
			sortOrder += sord;
			sortOrders.add(sortOrder);
		}
		ArrayList<NavigationItem> navigationItems = account.navigateChild(selectLevel, sortOrders);

		Iterator<NavigationItem> itrNavigationItem = navigationItems.iterator();
		while (itrNavigationItem.hasNext()) {

			NavigationItem navigationItem = itrNavigationItem.next();
			Account parentAccount = (Account) navigationItem.source;
			Account childAccount = (Account) navigationItem.destination;

			if ( lastChild.isEmpty() ) {
				lastParent = parentAccount.identification();
				lastChild = childAccount.identification();
				parents.add(lastParent);
			}
			else if (lastChild.equals(parentAccount.identification())){
				lastParent = parentAccount.identification();
				lastChild = childAccount.identification();
				parents.add(lastParent);
			}
			else {
				for (int ii = parents.size()-1; ii >= 0; --ii) {
					String identification = parents.get(ii);
					if ( identification.equals(parentAccount.identification()) ) {
						break;
					}
					else {
						parents.remove(ii);
					}
				}
				lastParent = parentAccount.identification();
				lastChild = childAccount.identification();
			}

			int level = parents.size();
			String parentIdentification = parentAccount.identification();
			createXml(document, elem_rows, level, parentIdentification, childAccount, objects, columns, treeGrid, key);
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param document
	 * @param elem_rows
	 * @param account
	 * @param objects
	 * @param columns
	 * @param treeGrid
	 * @throws IOException
	 */
	private void createXml(Document document, Element elem_rows, int level, String parentIdentification, Account childAccount, ArrayList<DecoratedEntity> objects, String[] columns, String treeGrid, String key) throws IOException {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		Element elem_row = null;
		Element elem_cell = null;

		String identification = childAccount.identification();
		elem_row = document.createElement("row");
		elem_row.setAttribute("id", identification);
		elem_rows.appendChild(elem_row);

		String cellString = "";
		Iterator<DecoratedEntity> itrColumns = objects.iterator();

		if (!key.isEmpty()){
			while (itrColumns.hasNext()) {
				DecoratedEntity decoratedEntity = itrColumns.next();

				ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
				//ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

				String columnId = columnMaster.getProperty("COLUMN_ID");
				if (columnId.equals(key)) {
					cellString = childAccount.getProperty(columnId);
					elem_cell = document.createElement("cell");
					elem_cell.appendChild(document.createTextNode(cellString));
					elem_row.appendChild(elem_cell);
					break;
				}
			}
		}

		itrColumns = objects.iterator();
		while (itrColumns.hasNext()) {
			DecoratedEntity decoratedEntity = itrColumns.next();

			ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
			//ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

			if ( columns != null ) {
				boolean isSkip = true;
				for (int ii = 0; ii < columns.length; ++ii) {
					String columnId1 = columns[ii];
					String columnId2 = columnMaster.getProperty("COLUMN_ID");
					if ( columnId1.equals(columnId2) ) {
						isSkip = false;
						break;
					}
				}
				if ( isSkip ) {
					continue;
				}
			}

			String columnId = columnMaster.getProperty("COLUMN_ID");
			cellString = childAccount.getProperty(columnId);
			elem_cell = document.createElement("cell");
			elem_cell.appendChild(document.createTextNode(cellString));
			elem_row.appendChild(elem_cell);
		}

		if (treeGrid.equals("true")){

			// Level
			cellString = Integer.toString(level);
			elem_cell = document.createElement("cell");
			elem_cell.appendChild(document.createTextNode(cellString));
			elem_row.appendChild(elem_cell);

			// Parent
			cellString = parentIdentification;
			elem_cell = document.createElement("cell");
			elem_cell.appendChild(document.createTextNode(cellString));
			elem_row.appendChild(elem_cell);

			// IsLeaf
			String isLeaf = "";
			String expand = "";
			cellString = childAccount.getProperty("HAS_ACCOUNT");
			if ( cellString.equals("TRUE") ) {
				isLeaf = "false";
				expand = "true";
			}
			else {
				isLeaf = "true";
				expand = "false";
			}

			elem_cell = document.createElement("cell");
			elem_cell.appendChild(document.createTextNode(isLeaf));
			elem_row.appendChild(elem_cell);

			elem_cell = document.createElement("cell");
			elem_cell.appendChild(document.createTextNode(expand));
			elem_row.appendChild(elem_cell);
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doPost(request, response);

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_userid = (String)session.getAttribute("userid");
		if(in_userid == null) {
			logger.info("セッションにユーザIDが設定されていません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_oper = request.getParameter("oper");
		if ( in_oper == null ) {
			String messageString = "パラメータ（oper）が設定されていません。";
			logger.info(messageString);
			return;
		}

		if ( in_oper.equals("add") ) {
			buildAccount(request, response, in_userid);
		}
		else if ( in_oper.equals("edit") ) {
			modifyAccount(request, response, in_userid);
		}
		else if ( in_oper.equals("del") ) {
			deleteAccount(request, response, in_userid);
		}
		else if ( in_oper.equals("move_row_top") ) {
			moveRowTop(request, response, in_userid);
		}
		else if ( in_oper.equals("move_row_up") ) {
			moveRowUp(request, response, in_userid);
		}
		else if ( in_oper.equals("move_row_down") ) {
			moveRowDown(request, response, in_userid);
		}
		else if ( in_oper.equals("move_row_bottom") ) {
			moveRowBottom(request, response, in_userid);
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void buildAccount(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_identification = request.getParameter("IDENTIFICATION");
		if ( in_identification == null ) {
			String messageString = "パラメータ（IDENTIFICATION）が設定されていません。";
			logger.info(messageString);
			return;
		}

		ArrayList<String> insertParams = new ArrayList<String>();
		ArrayList<Object> insertValues  = new ArrayList<Object>();

		insertParams.clear();
		insertValues.clear();

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects("ACCOUNT");
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			boolean columnEditable = Boolean.valueOf(metaColumn.getProperty("EDITABLE"));
			if ( columnEditable ) {
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String in_insertParam = request.getParameter(columnId);
				if ( in_insertParam == null || in_insertParam.isEmpty() ) {
					boolean columnNotNull = Boolean.valueOf(metaColumn.getProperty("COLUMN_NOT_NULL"));
					if ( columnNotNull ) {
						String messageString = "パラメータ（";
						messageString += columnId;
						messageString += "）が設定されていません。";
						logger.info(messageString);
						return;
					}
				}
				else {
					insertParams.add(columnId);
					insertValues.add(in_insertParam);
				}
			}
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();
			ArrayList<Account> accounts;

			//勘定科目種類取得
			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_identification);
			accounts = clsAccount.select(condition, conditionValues);
			if ( accounts.size() == 0 ) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}

			Account account = accounts.get(0);
			String accountType = account.getProperty("ACCOUNT_TYPE");

			//勘定科目ID最大値取得
			ArrayList<String> selectParams = new ArrayList<String>();
			selectParams.clear();
			selectParams.add("MAX(ACCOUNT_NUMBER) AS ACCOUNT_NUMBER");
			condition = "ACCOUNT_TYPE = ?";
			conditionValues.clear();
			conditionValues.add(accountType);
			ArrayList<ArrayList<String>> maxValues = clsAccount.select(selectParams, condition, conditionValues);
			String strMaxOfAccountNumber = maxValues.get(0).get(0);
			String strMaxOfAccountNumberPrefix = strMaxOfAccountNumber.substring(0, 1);
			String strMaxOfAccountNumberBody = strMaxOfAccountNumber.substring(1, strMaxOfAccountNumber.length());
			int intMaxOfAccountNumber = Integer.parseInt(strMaxOfAccountNumberBody);
			++intMaxOfAccountNumber;
			strMaxOfAccountNumber = String.format("%s%07d", strMaxOfAccountNumberPrefix, intMaxOfAccountNumber);

			//追加パラメータ設定
			insertParams.add("ACCOUNT_NUMBER");
			insertParams.add("ACCOUNT_TYPE");
			insertParams.add("DEBIT_CREDIT_TYPE");
			insertParams.add("BP_TYPE");
			insertParams.add("DEPARTMENT_NUMBER");

			insertValues.add(strMaxOfAccountNumber);
			insertValues.add(accountType);
			insertValues.add(account.getProperty("DEBIT_CREDIT_TYPE"));
			insertValues.add(account.getProperty("BP_TYPE"));
			insertValues.add(account.getProperty("DEPARTMENT_NUMBER"));

			//勘定科目登録
			Account newAccount = clsAccount.create(insertParams, insertValues);
			account.appendChild(newAccount);

			db.commit();

			String delimiter = "";
			StringBuffer responseText = new StringBuffer();
			for (int ii = 0; ii < metaColumns.size(); ++ii) {
				MetaColumn metaColumn = metaColumns.get(ii);
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String value = newAccount.getProperty(columnId);
				responseText.append(delimiter);
				responseText.append(columnId);
				responseText.append("=");
				responseText.append(value);
				delimiter = ",";
			}

			//登録結果出力
			response.getWriter().write(responseText.toString());

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public void modifyAccount(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_identification = request.getParameter("IDENTIFICATION");
		if ( in_identification == null ) {
			String messageString = "パラメータ（IDENTIFICATION）が設定されていません。";
			logger.info(messageString);
			return;
		}

		ArrayList<String> updateParams = new ArrayList<String>();
		ArrayList<Object> updateValues  = new ArrayList<Object>();

		updateParams.clear();
		updateValues.clear();

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects("ACCOUNT");
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			boolean columnEditable = Boolean.valueOf(metaColumn.getProperty("EDITABLE"));
			if ( columnEditable ) {
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String in_updateParam = request.getParameter(columnId);
				if ( in_updateParam != null && !in_updateParam.isEmpty() ) {
					updateParams.add(columnId);
					updateValues.add(in_updateParam);
				}
			}
		}

		String in_consumption_tax_rate = request.getParameter("CONSUMPTION_TAX_RATE");

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_identification);

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);

			ArrayList<Account> acconts1 = clsAccount.select(condition, conditionValues);
			if ( acconts1.size() == 0 ) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}
			Account account1 = acconts1.get(0);

			int result = clsAccount.update(updateParams, updateValues, condition, conditionValues);
			if ( result < 0 ) {
				db.rollback();

				String messageString = "勘定科目の更新に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}

			ArrayList<Account> acconts2 = clsAccount.select(condition, conditionValues);
			if ( acconts2.size() == 0 ) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}
			Account account2 = acconts2.get(0);

			//消費税率変更による税込価格再計算
			if ( in_consumption_tax_rate != null ) {
				int consumption_tax_rate = Integer.parseInt(in_consumption_tax_rate);

				ArrayList<String> inSortParams = null;
				ArrayList<NavigationItem> naviItemSet = account2.navigatePart(inSortParams);
				for (int ii = 0; ii < naviItemSet.size(); ++ii) {
					NavigationItem naviItem = naviItemSet.get(ii);
					Part part = (Part)naviItem.destination;
					boolean tax_inclusive = Boolean.parseBoolean(part.getProperty("TAX_INCLUSIVE"));
					if ( !tax_inclusive ) {
						int amount = Integer.parseInt(part.getProperty("PRICE"));
						amount = amount + (amount * consumption_tax_rate)/100;
						part.setProperty("AMOUNT", String.valueOf(amount));
					}
				}
			}

			db.commit();

			String delimiter = "";
			StringBuffer responseText = new StringBuffer();
			for (int ii = 0; ii < metaColumns.size(); ++ii) {
				MetaColumn metaColumn = metaColumns.get(ii);
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String value1 = account1.getProperty(columnId);
				String value2 = account2.getProperty(columnId);
				if ( !value1.equals(value2) ) {
					responseText.append(delimiter);
					responseText.append(columnId);
					responseText.append("=");
					responseText.append(value2);
					delimiter = ",";
				}
			}

			//登録結果出力
			response.getWriter().write(responseText.toString());

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void deleteAccount(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_identification = request.getParameter("IDENTIFICATION");
		if ( in_identification == null ) {
			String messageString = "パラメータ（IDENTIFICATION）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_identification);

			ArrayList<Account> accounts;
			accounts = clsAccount.select(condition, conditionValues);
			if ( accounts.size() == 0 ) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}

			Account account;
			account = accounts.get(0);
			int result = account.delete();

			if ( result < 0 ) {
				db.rollback();

				String messageString = "勘定科目の削除に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void moveRowTop(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_rowid_p = request.getParameter("rowid_p");
		if ( in_rowid_p == null ) {
			String messageString = "パラメータ（rowid_p）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String rowid_c = request.getParameter("rowid_c");
		if ( rowid_c == null ) {
			String messageString = "パラメータ（rowid_c）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_rowid_p);

			int result = 0;
			ArrayList<Account> accounts;
			accounts = clsAccount.select(condition, conditionValues);
			if (accounts.size() == 0) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_rowid_p;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}

			Account account = accounts.get(0);

			ArrayList<String> inSortParams = null;
			ArrayList<NavigationItem> naviItemSet = account.navigateChild("single", inSortParams);

			boolean isFound = false;

			Iterator<NavigationItem> itrNaviItem = naviItemSet.iterator();
			while(itrNaviItem.hasNext()) {
				NavigationItem naviItem = itrNaviItem.next();

				//子勘定科目
				Account childAccount = (Account)naviItem.destination;

				//勘定科目構成
				AccountStructure accountStructure = (AccountStructure)naviItem.relation;

				String identification_c = childAccount.identification();
				if ( identification_c.equals(rowid_c)) {
					result = accountStructure.setProperty("STRUCT_ORDER", "1");
					isFound = true;
				}
				else {
					if ( isFound ) {
						break;
					}
					else {
						String strStructOrder = accountStructure.getProperty("STRUCT_ORDER");
						int intStructOrder = Integer.parseInt(strStructOrder);
						++intStructOrder;
						result = accountStructure.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
						if ( result < 0 ) {
							String messageString = "勘定科目の順序変更に失敗しました。勘定科目名称:" + childAccount.getProperty("NAME");
							logger.warning(messageString);
							response.getWriter().write(messageString);
							break;
						}
					}
				}
			}

			if ( result < 0 ) {
				db.rollback();
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void moveRowUp(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_rowid_p = request.getParameter("rowid_p");
		if ( in_rowid_p == null ) {
			String messageString = "パラメータ（rowid_p）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String rowid_c = request.getParameter("rowid_c");
		if ( rowid_c == null ) {
			String messageString = "パラメータ（rowid_c）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_rowid_p);

			int result = 0;
			ArrayList<Account> accounts;
			accounts = clsAccount.select(condition, conditionValues);
			if (accounts.size() == 0) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_rowid_p;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}
			Account account = accounts.get(0);

			ArrayList<String> inSortParams = null;
			ArrayList<NavigationItem> naviItemSet = account.navigateChild("single", inSortParams);

			AccountStructure lastAccountStructure = null;

			Iterator<NavigationItem> itrNaviItem = naviItemSet.iterator();
			while(itrNaviItem.hasNext()) {
				NavigationItem naviItem = itrNaviItem.next();

				//子勘定科目
				Account childAccount = (Account)naviItem.destination;

				//勘定科目構成
				AccountStructure accountStructure = (AccountStructure)naviItem.relation;

				String identification_c = childAccount.identification();
				if ( identification_c.equals(rowid_c)) {
					String strStructOrder = accountStructure.getProperty("STRUCT_ORDER");
					int intStructOrder = Integer.parseInt(strStructOrder);
					if (intStructOrder == 1) {
						break;
					}

					--intStructOrder;
					result = accountStructure.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
					if ( result < 0 ) {
						String messageString = "勘定科目の順序変更に失敗しました。勘定科目名称:" + childAccount.getProperty("NAME");
						logger.warning(messageString);
						response.getWriter().write(messageString);
						break;
					}

					strStructOrder = lastAccountStructure.getProperty("STRUCT_ORDER");
					intStructOrder = Integer.parseInt(strStructOrder);
					++intStructOrder;
					result = lastAccountStructure.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
					if ( result < 0 ) {
						String messageString = "勘定科目の順序変更に失敗しました。勘定科目名称:" + childAccount.getProperty("NAME");
						logger.warning(messageString);
						response.getWriter().write(messageString);
						break;
					}

					break;
				}
				else {
					lastAccountStructure = accountStructure;
				}
			}

			if ( result < 0 ) {
				db.rollback();
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void moveRowDown(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_rowid_p = request.getParameter("rowid_p");
		if ( in_rowid_p == null ) {
			String messageString = "パラメータ（rowid_p）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String rowid_c = request.getParameter("rowid_c");
		if ( rowid_c == null ) {
			String messageString = "パラメータ（rowid_c）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_rowid_p);

			int result = 0;
			ArrayList<Account> accounts;
			accounts = clsAccount.select(condition, conditionValues);
			if (accounts.size() == 0) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_rowid_p;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}
			Account account = accounts.get(0);

			ArrayList<String> inSortParams = null;
			ArrayList<NavigationItem> naviItemSet = account.navigateChild("single", inSortParams);

			boolean isFound = false;

			Iterator<NavigationItem> itrNaviItem = naviItemSet.iterator();
			while(itrNaviItem.hasNext()) {
				NavigationItem naviItem = itrNaviItem.next();

				//子勘定科目
				Account childAccount = (Account)naviItem.destination;

				//勘定科目構成
				AccountStructure accountStructure = (AccountStructure)naviItem.relation;

				String identification_c = childAccount.identification();
				if ( identification_c.equals(rowid_c)) {

					String strStructOrder = accountStructure.getProperty("STRUCT_ORDER");
					int intStructOrder = Integer.parseInt(strStructOrder);
					if (intStructOrder < naviItemSet.size()) {
						++intStructOrder;
					}

					result = accountStructure.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
					if ( result < 0 ) {
						String messageString = "勘定科目の順序変更に失敗しました。勘定科目名称:" + childAccount.getProperty("NAME");
						logger.warning(messageString);
						response.getWriter().write(messageString);
						break;
					}

					isFound = true;
				}
				else {
					if ( isFound ) {

						String strStructOrder = accountStructure.getProperty("STRUCT_ORDER");
						int intStructOrder = Integer.parseInt(strStructOrder);
						if (intStructOrder > 1) {
							--intStructOrder;
						}

						result = accountStructure.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
						if ( result < 0 ) {
							String messageString = "勘定科目の順序変更に失敗しました。勘定科目名称:" + childAccount.getProperty("NAME");
							logger.warning(messageString);
							response.getWriter().write(messageString);
							break;
						}

						break;
					}
				}
			}

			if ( result < 0 ) {
				db.rollback();
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void moveRowBottom(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_rowid_p = request.getParameter("rowid_p");
		if ( in_rowid_p == null ) {
			String messageString = "パラメータ（rowid_p）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String rowid_c = request.getParameter("rowid_c");
		if ( rowid_c == null ) {
			String messageString = "パラメータ（rowid_c）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassAccount clsAccount = new ClassAccount(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_rowid_p);

			int result = 0;
			ArrayList<Account> accounts;
			accounts = clsAccount.select(condition, conditionValues);
			if (accounts.size() == 0) {
				db.rollback();

				String messageString = "勘定科目の検索に失敗しました。ID:" + in_rowid_p;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}
			Account account = accounts.get(0);

			ArrayList<String> inSortParams = null;
			ArrayList<NavigationItem> naviItemSet = account.navigateChild("single", inSortParams);

			boolean isFound = false;

			Iterator<NavigationItem> itrNaviItem = naviItemSet.iterator();
			while(itrNaviItem.hasNext()) {
				NavigationItem naviItem = itrNaviItem.next();

				//子勘定科目
				Account childAccount = (Account)naviItem.destination;

				//勘定科目構成
				AccountStructure accountStructure = (AccountStructure)naviItem.relation;

				String identification_c = childAccount.identification();
				if ( identification_c.equals(rowid_c)) {
					result = accountStructure.setProperty("STRUCT_ORDER", String.valueOf(naviItemSet.size()));
					isFound = true;
				}
				else {
					if ( isFound ) {

						String strStructOrder = accountStructure.getProperty("STRUCT_ORDER");
						int intStructOrder = Integer.parseInt(strStructOrder);
						if (intStructOrder > 1) {
							--intStructOrder;
						}

						result = accountStructure.setProperty("STRUCT_ORDER", String.valueOf(intStructOrder));
						if ( result < 0 ) {
							String messageString = "勘定科目の順序変更に失敗しました。勘定科目名称:" + childAccount.getProperty("NAME");
							logger.warning(messageString);
							response.getWriter().write(messageString);
							break;
						}
					}
				}
			}

			if ( result < 0 ) {
				db.rollback();
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}
}
