/**
 *
 */
package common;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

/**
 *
 * @author 無糖ブラック
 *
 */
public class XSVReader {

	/**
	 *
	 */
	private String m_path;

	/**
	 *
	 */
	private String m_delimiter;

	/**
	 *
	 */
	public XSVReader(String path, String delimiter) {
		this.m_path = path;
		this.m_delimiter = delimiter;
	}

	/**
	 *
	 * @return
	 * @throws IOException
	 */
	public ArrayList<String[]> readLines() throws IOException {

		ArrayList<String[]> lines = new ArrayList<String[]>();

		FileReader in = new FileReader(m_path);
		BufferedReader br = new BufferedReader(in);

		String line = "";
		while ((line = br.readLine()) != null) {
			if (line.equals("")) {
				continue;
			}
			lines.add(line.split(m_delimiter));
		}

		if (br != null) {
			br.close();
		}
		if (in != null) {
			in.close();
		}

		return lines;
	}
}
