/**
 * SuperC Main program
 *
 *
 */

.incdir  "./include/"
.include "spc.inc"
.include "var.inc"

.incdir  "./table/"
.include "id666.tab"
.include "dspreg.tab"


.incdir  ""
.bank 3 slot 3
.org 0
.section "__main__" force
;--------------------------------------------------
; Start - SPC PROGRAM ROOT
;   Level       : - (root Level)
;   Input       : none
;   Output      : none
;   Description : rootプログラム
;--------------------------------------------------
Start:
; ダイレクトページの初期化
	di
	setp
	mov   a,#0
	mov   x,a
-	mov   (x)+,a
	cmp   x,#0
	bne   -
	clrp
-	mov   (x)+,a
	cmp   x,#$f0
	bcc   -
; レジスタ等の初期化
	mov   x,#$ff
	mov   sp,x  ; スタックポインタ初期化
	mov   x,a
-	mov   a, !TAB_DSP_INIT+x
	bmi   +
	mov   SPC_REGADDR,a
	inc   x
	mov   a,!TAB_DSP_INIT+x
	mov   SPC_REGDATA,a
	inc   x
	bra   -
+	mov   SPC_TIMER0,  #TIMER
	mov   SPC_CONTROL, #(CNT_ST0|CNT_PC10|CNT_PC32) ; タイマー初期化 / ポートクリア
	mov   musicTempo, #MUSIC_TEMPO_DEFAULT         ; 音楽テンポ初期化

; --- メインループ
_mainLoop:
	call  IOProc               ; SNES<-->APU通信処理
	call  QueProc              ; Que消化処理
	mov   y,SPC_COUNTER0
	beq   _mainLoop
-	push  y
	call  QueDelete            ; Queの掃除
;--- 効果音
	mov   a, #SND_TEMPO
	clrc
	adc   a, sndTempoCounter
	mov   sndTempoCounter, a
	bcc   _Music
	call  SoundEffectProc

_Music:
	mov   a, musicTempo
	clrc
	adc   a, musicTempoCounter
	mov   musicTempoCounter, a
	bcc   _End
	call  MusicProc
	
_End:
	pop   y
	dec   y
	bne   -         ; カウンタの回数分実行
	; todo DSPレジスタ書き込み処理
	bra   _mainLoop
.ends


.section "initData" free

TAB_DSP_INIT:
	.db   DSP_FLG,    (FLG_ECEN|FLG_MUTE|FLG_RES)
	.db   DSP_MVOLL,  64
	.db   DSP_MVOLR,  64
	.db   DSP_EVOLL,   0
	.db   DSP_EVOLR,   0
	.db   DSP_KON,     0
	.db   DSP_KOF,     0
	.db   DSP_EON,     0
	.db   DSP_PMON,    0
	.db   DSP_NON,     0
	.db   DSP_DIR,   DIR
	.db   DSP_EDL      0
	.db   DSP_ESA    $ff

	.db   $ff ; termination code
.ends
