/**
 * SuperC RAM DEFINE
 *
 *
 */

.ifndef _RAM_INC
.define _RAM_INC

.define EMPTY $ff
.emptyfill EMPTY

;------------------------------------------------
; RAM
;------------------------------------------------

;------------------------------
; DirectPage Pg0
;------------------------------
;     |------------ドラム缶-----------|
;     +---+---+---+---+---+---+---+---+
; $00 |                               |
;  :  |     テンポラリ変数用予約      |
; $07 |                               |
;     +---+---+---+---+---+---+---+---+
; $08 |                               |
;  :  |    LV1:メインルーチン予約     |
; $0f |                               |
;     +---+---+---+---+---+---+---+---+
; $10 |                               |
;  :  |  LV2:メインサブルーチン予約   |
; $17 |                               |
;     +---+---+---+---+---+---+---+---+
; $18 |      システムキュー先頭       |
;     +---+---+---+---+---+---+---+---+
; $19 |      システムキュー末尾       |
;     +---+---+---+---+---+---+---+---+

.enum $18
	dpQueHead                   db
	dpQueTail                   db
	; todo : DSPレジスタ書き込み制御用定義
	sndTempoCounter             db                  ; これは
	musicTempoCounter           db                  ; 全部ゴミなので
	musicTempo                  db                  ; あとで消す
;----------------------------------------
	PAGE0TAIL                   db                  ; ページ0末端識別用(コンパイラで使用)
.ende

;------------------------------
; DirectPage Pg1
;------------------------------
;     |--------- --ドラム缶-----------|
;     +---+---+---+---+---+---+---+---+
; $00 |                               |
;  :  |     システムキューで予約      |
; $7f |                               |
;     +---+---+---+---+---+---+---+---+
; $80 |   |   |   |   |   |   |   |   |

.define QUEMASK $7f

.enum QUEMASK+1
;----------------------------------------
	PAGE1TAIL                   db                  ; ページ1末端識別用(コンパイラで使用)
.ende


;--------------------------------------------------
; ダイレクトページRAMチェック
;--------------------------------------------------
; ページ０
.if PAGE0TAIL > $f0
	.print "[ ERROR ] ダイレクトページ０の定義範囲オーバー\n"
	.fail
.endif

; ページ１
.if PAGE1TAIL > $f0
	.print "[ ERROR ] ダイレクトページ１の定義範囲オーバー\n"
	.fail
.endif
.if PAGE1TAIL > $e0
	.print "[ WARNING ] スタックに使えるRAMが32バイト以下です\n"
.endif


;--------------------------------------------------
; RAM定義( $0200 ～, ふつうのRAM)
;--------------------------------------------------
.enum $0200
	; todo : RAM定義を追加する
;----------------------------------------
	__CODE_START__              db                  ; RAM領域末端識別用(コンパイラで使用)  
.ende


;--------------------------------------------------
; プログラム開始エリアの計算
; ( バンクマップ定義で使用 )
;--------------------------------------------------
.define __RAMSIZE__ __CODE_START__-$200

.endif
