<?php
// 指定日表示
class MonthlyController extends AppController {
	var $uses = array('User', 'Data', 'Course');
	var $helpers = array('Html', 'Js');


	function index() {

		$begindate = '';
		if (isset($_POST['dates'])) {
			$begindate = h($_POST['dates']);
		} else {
			$begindate = date('Y-m-01');
		}
		$begintime = strtotime($begindate);
		$enddate = date('Y-m-t', $begintime);
		$endday = date('t', $begintime);

		$all = $this->_monthly_report($begindate);

		// 月指定メニュー作成
		$this->set('datemenu', $this->_monthmenu(6, $begindate));

		// 表示
		$table = '<table class="sheet">';
		$table .= '<thead><tr>'.PHP_EOL;

		$table .= '<td class="name">なまえ</td>';
		for ( $i = 1 ; $i <= $endday ; $i++ ) {
			$table .= '<td colspan=2>' . $i . '</td>';
		}

		$table .= '</tr><tr><td>';
		for ( $i = 1 ; $i <= $endday ; $i++ ) {
			$table .= '<th class="time">入</td><td class="time">退</td>';
		}
		$table .= '</tr></thead>';
		$table .= '<tbody>'.PHP_EOL;
		foreach ($all as $key => $line ) {
			$table .= '<tr><td>'.$key.'</td>';
			for ( $i = 1 ; $i <= $endday ; $i++ ) {
				$daydata = '';
				if (isset($line["$i"])) {
					$daydata = $line["$i"];
				}
				$begintime = '';
				$endtime = '';
				if (isset($daydata[0])) {
					//$begintime = $daydata[0];
					$begintime = date('H:i', strtotime($daydata[0]));
				}
				if (isset($daydata[1])) {
					//$endtime = $daydata[1];
					$endtime = date('H:i', strtotime($daydata[1]));
				}
				$table .= '<td>'."$begintime".'</td><td>'."$endtime".'</td>';
			}
			$table .= '</tr>';
		}
		$table .= '</tbody>';
		$table .= '</table>';
		$this->set('dailytable', $table);

	}
	
	function _monthly_report($begindate) {
	
		$begintime = strtotime($begindate);
		$enddate = date('Y-m-t', $begintime);
		$endday = date('t', $begintime);

		// 対象月のデータ取得
		$query = array('conditions' => array( 'create_t >=' => "$begindate",
							'create_t <=' => "$enddate" ),
				'order' => array('create_t'));
		$datas = $this->Data->find('all', $query);

		// $all = [name][day][0|1] = 'time';
		$all = array();

		$daily = array();
		foreach ( $datas as $data ) {
			$data = $data['Data'];
			$name = $data['name'];
			$create = $data['create_t'];
			$day = date('d', strtotime("$create"));
			if (isset($all["$name"]["$day"][0])) {
				if (isset($all["$name"]["$day"][1])) {
					unset($all["$name"]["$day"][1]);
				}
				$all["$name"]["$day"][1] = "$create";

			} else {
				$all["$name"]["$day"][0] = "$create";
			}
		}
		
		return $all;
	}

	public function save() {
		$this->layout = false;
		//$this->autoRender = false;

		$begindate = '';
		if (isset($_POST['dates'])) {
			$begindate = h($_POST['dates']);
		} else {
			$begindate = date('Y-m-01');
		}
		$begintime = strtotime($begindate);
		$enddate = date('Y-m-t', $begintime);
		$endday = date('t', $begintime);

		$all = $this->_monthly_report($begindate);
		
		$csv = 'なまえ';
		for ( $i = 1 ; $i <= $endday ; $i++ ) {
			$csv .= "\t".$i."\t";
		}
		$csv .= PHP_EOL;

		for ( $i = 1 ; $i <= $endday ; $i++ ) {
			$csv .= "\t入\t退";
		}
		$csv .= PHP_EOL;
		
		foreach ($all as $key => $line ) {
			$csv .= $key;
			for ( $i = 1 ; $i <= $endday ; $i++ ) {
				$daydata = '';
				if (isset($line["$i"])) {
					$daydata = $line["$i"];
				}
				$begintime = '';
				$endtime = '';
				if (isset($daydata[0])) {
					$begintime = date('H:i', strtotime($daydata[0]));
				}
				if (isset($daydata[1])) {
					$endtime = date('H:i', strtotime($daydata[1]));
				}
				$csv .= "\t"."$begintime"."\t"."$endtime";
			}
			$csv .= PHP_EOL;
		}
		// $csvをsjisに変換

		$this->set('contents', $csv);
	}
}
?>

