#pragma once

#include <algorithm>

namespace MG {

struct Rectangle
{
	int16_t x;
	int16_t y;
	uint16_t w;
	uint16_t h;
	
	int16_t Left() const { return x; }
	int16_t Right() const { return x+w; }
	int16_t Top() const { return y; }
	int16_t Bottom() const { return y+h; }
	
	void Offset(int16_t x, int16_t y);
	static Rectangle Offset(const Rectangle& r, int16_t x, int16_t y);
	
	bool Contains(int16_t x, int16_t y) const;
	bool Contains(const Rectangle& r) const;
	
	void Intersect(const Rectangle& r);
	static Rectangle Intersect(const Rectangle& r1, const Rectangle& r2);
	
	void Union(int16_t x, int16_t y);
	void Union(const Rectangle& r);
	static Rectangle Union(const Rectangle& r, int16_t x, int16_t y);
	static Rectangle Union(const Rectangle& r1, const Rectangle& r2);
};

} // namespace MG

