#ifndef MG_H_INCLUDED__
#define MG_H_INCLUDED__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

// type definitions

typedef struct mgPoint_t {
	int16_t x;
	int16_t y;
} mgPoint;

typedef struct mgRect_t {
	mgPoint pos;
	uint16_t w;
	uint16_t h;
} mgRect;

typedef uint8_t mgEnum;

typedef struct mgElement_t {
	mgEnum behavior;
	mgEnum id;
	mgEnum parent;
	
	mgRect rect;
	bool_t bEnable;
	bool_t bVisible;
	bool_t bNeedsToDraw;
	
} mgElement;

typedef struct mgBehavior_t {
	mgEventListerFunc pDraw;
	mgEventListerFunc pHitTest;
	mgEventListerFunc pOnMouseDown;
	mgEventListerFunc pOnMouseUp;
	mgEventListerFunc pOnMouseMove;
} mgBehavior;

typedef enum mgEventType_t {
	mgEventType_MouseDown,
	mgEventType_MouseUp,
	mgEventType_MouseMove,
	
} mgEventType;

typedef struct mgEventInfo_t {
	mgElement* pTarget;
	mgEventType type;
	mgPoint pos;
} mgEventInfo;

typedef enum mgElementType_t {
	mgElementType_Canvas,
	mgElementType_Label,
	mgElementType_Button,
	
} mgElementType;

typedef bool (*mgEventListenerFunc) (mgEventInfo* pInfo);

// function

int16_t mg_left(const mgRect* p) const		{ return p->pos.x; }
int16_t mg_right(const mgRect* p) const		{ return mg_left(p) + p->w; }
int16_t mg_top(const mgRect* p) const		{ return p->pos.y; }
int16_t mg_bottom(const mgRect* p) const	{ return mg_top(p) + p->h; }

void mg_offset(mgRect* p, mgPoint pt);
bool_t mg_in(const mgRect* p, mgPoint pt);

bool_t mg_contains(const mgRect* p, const mgRect* pCheck);
void mg_intersect(const mgRect* p1, const mgRect* p2, mgRect* pResult);

void mg_unionPoint(const mgRect* pRect, mgPoint pt, mgRect* pResult);
void mg_unionRect(const mgRect* p1, const mgRect* p2, mgRect* pResult);

void mg_setEventListener(mgEnum id, mgEventType type, mgEventListenerFunc func);

void mg_initialize();

void mg_registerElement(mgElement* p);
void mg_unregisterElement(mgElement* p);

void mg_notifyEvent(id_t parent, mgEventInfo* pEvent);

#ifdef __cplusplus
}; /* extern "C" */
#endif /* __cplusplus */

#endif // #ifndef MG_H_INCLUDED__
