#pragma once

#include "rectangle.h"
#include "bitmap.h"

namespace MG {

struct Color
{
	uint8_t r;
	uint8_t g;
	uint8_t b;
	uint8_t a;
};

class IRenderer
{
public:
	virtual void SetClippingRectangle(const Rectangle& rec) = 0;
	
	virtual void SetPixel(uint16_t x, uint16_t y, Color c) = 0;
	virtual Color GetPixel(uint16_t x, uint16_t y) = 0;
	
	virtual void DrawHorizontalLine(float x1, float x2, float y, Color c) = 0;
	virtual void DrawVerticalLine(float x, float y1, float y2, Color c) = 0;
	virtual void DrawLine(float x1, float y1, float x2, float y2, Color c) = 0;
	
	virtual void FillRectangle(const Rectangle& rec, Color c) = 0;
	
	virtual void DrawBitmap(
		const Bitmap& bmp,
		const Rectangle& src, const Rectangle& dst
	) = 0;
	
	virtual void DrawText(uint8_t font, const char* str, size_t len, float x, float y, Color c) = 0;
	virtual void GetTextExtents(uint8_t font, const char* str, size_t len, int* charExtents, int& sx, int& sy) = 0;
	
	virtual Rectangle GetUpdatedRect() = 0;
	virtual void ClearUpdatedRect() = 0;
	
};

} // namespace MG

