#pragma once

#include "renderer.h"
#include "optional.h"
#include "varray.h"

namespace MG {

class Element
{
public:
	typedef uint8_t id_t;
	
	Element(size_t nMaxEvents);
	virtual ~Element() {}
	
	virtual void Draw(int16_t offsetX, int16_t offsetY, IRenderer& renderer);
	virtual bool HitTest(int16_t x, int16_t y) const;
	
	virtual void OnMouseDown(int16_t x, int16_t y);
	virtual void OnMouseUp(int16_t x, int16_t y);
	virtual void OnMouseMove(int16_t x, int16_t y);
	
	Rectangle rect_;	// positioning, size
	bool needsToDraw_;
	
	struct IBackground {
		virtual void Draw(const Rectangle& rect, IRenderer& renderer) = 0;
	};
	IBackground* pBG_;
	
	Element* GetParent() const { return pParent_; }
	void SetParent(Element* pParent) { pParent_ = pParent; }
	
	// event
	enum EventType {
		EventType_MouseDown,
		EventType_MouseUp,
		EventType_MouseMove,
		
		EventType_End,
	};
	struct Event
	{
		Element* target;
		uint8_t type;
		int16_t x;
		int16_t y;
	};
	typedef void (*EventListener)(void* param, const Event& e);
	struct EventListenerEntry {
		int type;
		EventListener listener;
	};
	void* pEventListenerParam_;
	void AddEventListener(int type, const EventListener& listener);
	void RemoveEventListener(int type, const EventListener& listener);
	static Element* s_pCapture_;
protected:
	Element* pParent_;
	
	varray<EventListenerEntry> eventEntries_;
	void fireEventListener(const Event& e);
};

} // namespace MG

